<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Overview StructType
 * @subpackage Structs
 */
class JP_Overview extends AbstractStructBase
{
    /**
     * The Building
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Building;
    /**
     * The Span
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Span;
    /**
     * The Servicelevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Servicelevel;
    /**
     * The Tonnage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Tonnage;
    /**
     * The Sleeve
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Sleeve;
    /**
     * The Length
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Length;
    /**
     * The CabExt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CabExt;
    /**
     * The CabInt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CabInt;
    /**
     * The CabBal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CabBal;
    /**
     * The CapMaxCab
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CapMaxCab;
    /**
     * The CapTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CapTotal;
    /**
     * The Flag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Flag;
    /**
     * The Crew
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Crew;
    /**
     * The Decks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Decks;
    /**
     * The Refurbished
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Refurbished;
    /**
     * Constructor method for JP_Overview
     * @uses JP_Overview::setBuilding()
     * @uses JP_Overview::setSpan()
     * @uses JP_Overview::setServicelevel()
     * @uses JP_Overview::setTonnage()
     * @uses JP_Overview::setSleeve()
     * @uses JP_Overview::setLength()
     * @uses JP_Overview::setCabExt()
     * @uses JP_Overview::setCabInt()
     * @uses JP_Overview::setCabBal()
     * @uses JP_Overview::setCapMaxCab()
     * @uses JP_Overview::setCapTotal()
     * @uses JP_Overview::setFlag()
     * @uses JP_Overview::setCrew()
     * @uses JP_Overview::setDecks()
     * @uses JP_Overview::setRefurbished()
     * @param int $building
     * @param float $span
     * @param string $servicelevel
     * @param float $tonnage
     * @param float $sleeve
     * @param float $length
     * @param int $cabExt
     * @param int $cabInt
     * @param int $cabBal
     * @param int $capMaxCab
     * @param int $capTotal
     * @param string $flag
     * @param string $crew
     * @param int $decks
     * @param int $refurbished
     */
    public function __construct($building = null, $span = null, $servicelevel = null, $tonnage = null, $sleeve = null, $length = null, $cabExt = null, $cabInt = null, $cabBal = null, $capMaxCab = null, $capTotal = null, $flag = null, $crew = null, $decks = null, $refurbished = null)
    {
        $this
            ->setBuilding($building)
            ->setSpan($span)
            ->setServicelevel($servicelevel)
            ->setTonnage($tonnage)
            ->setSleeve($sleeve)
            ->setLength($length)
            ->setCabExt($cabExt)
            ->setCabInt($cabInt)
            ->setCabBal($cabBal)
            ->setCapMaxCab($capMaxCab)
            ->setCapTotal($capTotal)
            ->setFlag($flag)
            ->setCrew($crew)
            ->setDecks($decks)
            ->setRefurbished($refurbished);
    }
    /**
     * Get Building value
     * @return int|null
     */
    public function getBuilding()
    {
        return $this->Building;
    }
    /**
     * Set Building value
     * @param int $building
     * @return \StructType\JP_Overview
     */
    public function setBuilding($building = null)
    {
        // validation for constraint: int
        if (!is_null($building) && !(is_int($building) || ctype_digit($building))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($building, true), gettype($building)), __LINE__);
        }
        $this->Building = $building;
        return $this;
    }
    /**
     * Get Span value
     * @return float|null
     */
    public function getSpan()
    {
        return $this->Span;
    }
    /**
     * Set Span value
     * @param float $span
     * @return \StructType\JP_Overview
     */
    public function setSpan($span = null)
    {
        // validation for constraint: float
        if (!is_null($span) && !(is_float($span) || is_numeric($span))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($span, true), gettype($span)), __LINE__);
        }
        $this->Span = $span;
        return $this;
    }
    /**
     * Get Servicelevel value
     * @return string|null
     */
    public function getServicelevel()
    {
        return $this->Servicelevel;
    }
    /**
     * Set Servicelevel value
     * @param string $servicelevel
     * @return \StructType\JP_Overview
     */
    public function setServicelevel($servicelevel = null)
    {
        // validation for constraint: string
        if (!is_null($servicelevel) && !is_string($servicelevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicelevel, true), gettype($servicelevel)), __LINE__);
        }
        $this->Servicelevel = $servicelevel;
        return $this;
    }
    /**
     * Get Tonnage value
     * @return float|null
     */
    public function getTonnage()
    {
        return $this->Tonnage;
    }
    /**
     * Set Tonnage value
     * @param float $tonnage
     * @return \StructType\JP_Overview
     */
    public function setTonnage($tonnage = null)
    {
        // validation for constraint: float
        if (!is_null($tonnage) && !(is_float($tonnage) || is_numeric($tonnage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tonnage, true), gettype($tonnage)), __LINE__);
        }
        $this->Tonnage = $tonnage;
        return $this;
    }
    /**
     * Get Sleeve value
     * @return float|null
     */
    public function getSleeve()
    {
        return $this->Sleeve;
    }
    /**
     * Set Sleeve value
     * @param float $sleeve
     * @return \StructType\JP_Overview
     */
    public function setSleeve($sleeve = null)
    {
        // validation for constraint: float
        if (!is_null($sleeve) && !(is_float($sleeve) || is_numeric($sleeve))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sleeve, true), gettype($sleeve)), __LINE__);
        }
        $this->Sleeve = $sleeve;
        return $this;
    }
    /**
     * Get Length value
     * @return float|null
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param float $length
     * @return \StructType\JP_Overview
     */
    public function setLength($length = null)
    {
        // validation for constraint: float
        if (!is_null($length) && !(is_float($length) || is_numeric($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get CabExt value
     * @return int|null
     */
    public function getCabExt()
    {
        return $this->CabExt;
    }
    /**
     * Set CabExt value
     * @param int $cabExt
     * @return \StructType\JP_Overview
     */
    public function setCabExt($cabExt = null)
    {
        // validation for constraint: int
        if (!is_null($cabExt) && !(is_int($cabExt) || ctype_digit($cabExt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cabExt, true), gettype($cabExt)), __LINE__);
        }
        $this->CabExt = $cabExt;
        return $this;
    }
    /**
     * Get CabInt value
     * @return int|null
     */
    public function getCabInt()
    {
        return $this->CabInt;
    }
    /**
     * Set CabInt value
     * @param int $cabInt
     * @return \StructType\JP_Overview
     */
    public function setCabInt($cabInt = null)
    {
        // validation for constraint: int
        if (!is_null($cabInt) && !(is_int($cabInt) || ctype_digit($cabInt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cabInt, true), gettype($cabInt)), __LINE__);
        }
        $this->CabInt = $cabInt;
        return $this;
    }
    /**
     * Get CabBal value
     * @return int|null
     */
    public function getCabBal()
    {
        return $this->CabBal;
    }
    /**
     * Set CabBal value
     * @param int $cabBal
     * @return \StructType\JP_Overview
     */
    public function setCabBal($cabBal = null)
    {
        // validation for constraint: int
        if (!is_null($cabBal) && !(is_int($cabBal) || ctype_digit($cabBal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cabBal, true), gettype($cabBal)), __LINE__);
        }
        $this->CabBal = $cabBal;
        return $this;
    }
    /**
     * Get CapMaxCab value
     * @return int|null
     */
    public function getCapMaxCab()
    {
        return $this->CapMaxCab;
    }
    /**
     * Set CapMaxCab value
     * @param int $capMaxCab
     * @return \StructType\JP_Overview
     */
    public function setCapMaxCab($capMaxCab = null)
    {
        // validation for constraint: int
        if (!is_null($capMaxCab) && !(is_int($capMaxCab) || ctype_digit($capMaxCab))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($capMaxCab, true), gettype($capMaxCab)), __LINE__);
        }
        $this->CapMaxCab = $capMaxCab;
        return $this;
    }
    /**
     * Get CapTotal value
     * @return int|null
     */
    public function getCapTotal()
    {
        return $this->CapTotal;
    }
    /**
     * Set CapTotal value
     * @param int $capTotal
     * @return \StructType\JP_Overview
     */
    public function setCapTotal($capTotal = null)
    {
        // validation for constraint: int
        if (!is_null($capTotal) && !(is_int($capTotal) || ctype_digit($capTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($capTotal, true), gettype($capTotal)), __LINE__);
        }
        $this->CapTotal = $capTotal;
        return $this;
    }
    /**
     * Get Flag value
     * @return string|null
     */
    public function getFlag()
    {
        return $this->Flag;
    }
    /**
     * Set Flag value
     * @param string $flag
     * @return \StructType\JP_Overview
     */
    public function setFlag($flag = null)
    {
        // validation for constraint: string
        if (!is_null($flag) && !is_string($flag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flag, true), gettype($flag)), __LINE__);
        }
        $this->Flag = $flag;
        return $this;
    }
    /**
     * Get Crew value
     * @return string|null
     */
    public function getCrew()
    {
        return $this->Crew;
    }
    /**
     * Set Crew value
     * @param string $crew
     * @return \StructType\JP_Overview
     */
    public function setCrew($crew = null)
    {
        // validation for constraint: string
        if (!is_null($crew) && !is_string($crew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crew, true), gettype($crew)), __LINE__);
        }
        $this->Crew = $crew;
        return $this;
    }
    /**
     * Get Decks value
     * @return int|null
     */
    public function getDecks()
    {
        return $this->Decks;
    }
    /**
     * Set Decks value
     * @param int $decks
     * @return \StructType\JP_Overview
     */
    public function setDecks($decks = null)
    {
        // validation for constraint: int
        if (!is_null($decks) && !(is_int($decks) || ctype_digit($decks))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decks, true), gettype($decks)), __LINE__);
        }
        $this->Decks = $decks;
        return $this;
    }
    /**
     * Get Refurbished value
     * @return int|null
     */
    public function getRefurbished()
    {
        return $this->Refurbished;
    }
    /**
     * Set Refurbished value
     * @param int $refurbished
     * @return \StructType\JP_Overview
     */
    public function setRefurbished($refurbished = null)
    {
        // validation for constraint: int
        if (!is_null($refurbished) && !(is_int($refurbished) || ctype_digit($refurbished))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($refurbished, true), gettype($refurbished)), __LINE__);
        }
        $this->Refurbished = $refurbished;
        return $this;
    }
}
