<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelOptionCheckAvail StructType
 * @subpackage Structs
 */
class JP_HotelOptionCheckAvail extends AbstractStructBase
{
    /**
     * The Supplier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Supplier
     */
    public $Supplier;
    /**
     * The Board
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Board
     */
    public $Board;
    /**
     * The HotelRooms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_HotelRoom
     */
    public $HotelRooms;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Comment
     */
    public $Comments;
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The AdditionalElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelAdditionalElements
     */
    public $AdditionalElements;
    /**
     * The HotelContent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelContent
     */
    public $HotelContent;
    /**
     * The BillingOrganization
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BillingOrganization
     */
    public $BillingOrganization;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The PaymentDestination
     * @var bool
     */
    public $PaymentDestination;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * Constructor method for JP_HotelOptionCheckAvail
     * @uses JP_HotelOptionCheckAvail::setSupplier()
     * @uses JP_HotelOptionCheckAvail::setBoard()
     * @uses JP_HotelOptionCheckAvail::setHotelRooms()
     * @uses JP_HotelOptionCheckAvail::setComments()
     * @uses JP_HotelOptionCheckAvail::setPrices()
     * @uses JP_HotelOptionCheckAvail::setAdditionalElements()
     * @uses JP_HotelOptionCheckAvail::setHotelContent()
     * @uses JP_HotelOptionCheckAvail::setBillingOrganization()
     * @uses JP_HotelOptionCheckAvail::setRatePlanCode()
     * @uses JP_HotelOptionCheckAvail::setPaymentDestination()
     * @uses JP_HotelOptionCheckAvail::setStatus()
     * @param \StructType\JP_Supplier $supplier
     * @param \StructType\JP_Board $board
     * @param \ArrayType\ArrayOfJP_HotelRoom $hotelRooms
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param \StructType\JP_HotelAdditionalElements $additionalElements
     * @param \StructType\JP_HotelContent $hotelContent
     * @param \StructType\JP_BillingOrganization $billingOrganization
     * @param string $ratePlanCode
     * @param bool $paymentDestination
     * @param string $status
     */
    public function __construct(\StructType\JP_Supplier $supplier = null, \StructType\JP_Board $board = null, \ArrayType\ArrayOfJP_HotelRoom $hotelRooms = null, \ArrayType\ArrayOfJP_Comment $comments = null, \ArrayType\ArrayOfJP_Price $prices = null, \StructType\JP_HotelAdditionalElements $additionalElements = null, \StructType\JP_HotelContent $hotelContent = null, \StructType\JP_BillingOrganization $billingOrganization = null, $ratePlanCode = null, $paymentDestination = null, $status = null)
    {
        $this
            ->setSupplier($supplier)
            ->setBoard($board)
            ->setHotelRooms($hotelRooms)
            ->setComments($comments)
            ->setPrices($prices)
            ->setAdditionalElements($additionalElements)
            ->setHotelContent($hotelContent)
            ->setBillingOrganization($billingOrganization)
            ->setRatePlanCode($ratePlanCode)
            ->setPaymentDestination($paymentDestination)
            ->setStatus($status);
    }
    /**
     * Get Supplier value
     * @return \StructType\JP_Supplier|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param \StructType\JP_Supplier $supplier
     * @return \StructType\JP_HotelOptionCheckAvail
     */
    public function setSupplier(\StructType\JP_Supplier $supplier = null)
    {
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Get Board value
     * @return \StructType\JP_Board|null
     */
    public function getBoard()
    {
        return $this->Board;
    }
    /**
     * Set Board value
     * @param \StructType\JP_Board $board
     * @return \StructType\JP_HotelOptionCheckAvail
     */
    public function setBoard(\StructType\JP_Board $board = null)
    {
        $this->Board = $board;
        return $this;
    }
    /**
     * Get HotelRooms value
     * @return \ArrayType\ArrayOfJP_HotelRoom|null
     */
    public function getHotelRooms()
    {
        return $this->HotelRooms;
    }
    /**
     * Set HotelRooms value
     * @param \ArrayType\ArrayOfJP_HotelRoom $hotelRooms
     * @return \StructType\JP_HotelOptionCheckAvail
     */
    public function setHotelRooms(\ArrayType\ArrayOfJP_HotelRoom $hotelRooms = null)
    {
        $this->HotelRooms = $hotelRooms;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfJP_Comment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @return \StructType\JP_HotelOptionCheckAvail
     */
    public function setComments(\ArrayType\ArrayOfJP_Comment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_HotelOptionCheckAvail
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_HotelAdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_HotelAdditionalElements $additionalElements
     * @return \StructType\JP_HotelOptionCheckAvail
     */
    public function setAdditionalElements(\StructType\JP_HotelAdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get HotelContent value
     * @return \StructType\JP_HotelContent|null
     */
    public function getHotelContent()
    {
        return $this->HotelContent;
    }
    /**
     * Set HotelContent value
     * @param \StructType\JP_HotelContent $hotelContent
     * @return \StructType\JP_HotelOptionCheckAvail
     */
    public function setHotelContent(\StructType\JP_HotelContent $hotelContent = null)
    {
        $this->HotelContent = $hotelContent;
        return $this;
    }
    /**
     * Get BillingOrganization value
     * @return \StructType\JP_BillingOrganization|null
     */
    public function getBillingOrganization()
    {
        return $this->BillingOrganization;
    }
    /**
     * Set BillingOrganization value
     * @param \StructType\JP_BillingOrganization $billingOrganization
     * @return \StructType\JP_HotelOptionCheckAvail
     */
    public function setBillingOrganization(\StructType\JP_BillingOrganization $billingOrganization = null)
    {
        $this->BillingOrganization = $billingOrganization;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_HotelOptionCheckAvail
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get PaymentDestination value
     * @return bool|null
     */
    public function getPaymentDestination()
    {
        return $this->PaymentDestination;
    }
    /**
     * Set PaymentDestination value
     * @param bool $paymentDestination
     * @return \StructType\JP_HotelOptionCheckAvail
     */
    public function setPaymentDestination($paymentDestination = null)
    {
        // validation for constraint: boolean
        if (!is_null($paymentDestination) && !is_bool($paymentDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paymentDestination, true), gettype($paymentDestination)), __LINE__);
        }
        $this->PaymentDestination = $paymentDestination;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_HotelOptionCheckAvail
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_AvailStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
