<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PackageAvailAdvancedOptions StructType
 * @subpackage Structs
 */
class JP_PackageAvailAdvancedOptions extends JP_AvailAdvancedOptions
{
    /**
     * The ShowOnlyAvailable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowOnlyAvailable;
    /**
     * The ShowCompleteInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowCompleteInfo;
    /**
     * The TimeOut
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TimeOut;
    /**
     * Constructor method for JP_PackageAvailAdvancedOptions
     * @uses JP_PackageAvailAdvancedOptions::setShowOnlyAvailable()
     * @uses JP_PackageAvailAdvancedOptions::setShowCompleteInfo()
     * @uses JP_PackageAvailAdvancedOptions::setTimeOut()
     * @param bool $showOnlyAvailable
     * @param bool $showCompleteInfo
     * @param int $timeOut
     */
    public function __construct($showOnlyAvailable = null, $showCompleteInfo = null, $timeOut = null)
    {
        $this
            ->setShowOnlyAvailable($showOnlyAvailable)
            ->setShowCompleteInfo($showCompleteInfo)
            ->setTimeOut($timeOut);
    }
    /**
     * Get ShowOnlyAvailable value
     * @return bool|null
     */
    public function getShowOnlyAvailable()
    {
        return $this->ShowOnlyAvailable;
    }
    /**
     * Set ShowOnlyAvailable value
     * @param bool $showOnlyAvailable
     * @return \StructType\JP_PackageAvailAdvancedOptions
     */
    public function setShowOnlyAvailable($showOnlyAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($showOnlyAvailable) && !is_bool($showOnlyAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showOnlyAvailable, true), gettype($showOnlyAvailable)), __LINE__);
        }
        $this->ShowOnlyAvailable = $showOnlyAvailable;
        return $this;
    }
    /**
     * Get ShowCompleteInfo value
     * @return bool|null
     */
    public function getShowCompleteInfo()
    {
        return $this->ShowCompleteInfo;
    }
    /**
     * Set ShowCompleteInfo value
     * @param bool $showCompleteInfo
     * @return \StructType\JP_PackageAvailAdvancedOptions
     */
    public function setShowCompleteInfo($showCompleteInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($showCompleteInfo) && !is_bool($showCompleteInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showCompleteInfo, true), gettype($showCompleteInfo)), __LINE__);
        }
        $this->ShowCompleteInfo = $showCompleteInfo;
        return $this;
    }
    /**
     * Get TimeOut value
     * @return int|null
     */
    public function getTimeOut()
    {
        return $this->TimeOut;
    }
    /**
     * Set TimeOut value
     * @param int $timeOut
     * @return \StructType\JP_PackageAvailAdvancedOptions
     */
    public function setTimeOut($timeOut = null)
    {
        // validation for constraint: int
        if (!is_null($timeOut) && !(is_int($timeOut) || ctype_digit($timeOut))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeOut, true), gettype($timeOut)), __LINE__);
        }
        $this->TimeOut = $timeOut;
        return $this;
    }
}
