<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Rating StructType
 * @subpackage Structs
 */
class JP_Rating extends AbstractStructBase
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Value;
    /**
     * The SubRatings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_SubRating
     */
    public $SubRatings;
    /**
     * Constructor method for JP_Rating
     * @uses JP_Rating::setValue()
     * @uses JP_Rating::setSubRatings()
     * @param float $value
     * @param \ArrayType\ArrayOfJP_SubRating $subRatings
     */
    public function __construct($value = null, \ArrayType\ArrayOfJP_SubRating $subRatings = null)
    {
        $this
            ->setValue($value)
            ->setSubRatings($subRatings);
    }
    /**
     * Get Value value
     * @return float
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\JP_Rating
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get SubRatings value
     * @return \ArrayType\ArrayOfJP_SubRating|null
     */
    public function getSubRatings()
    {
        return $this->SubRatings;
    }
    /**
     * Set SubRatings value
     * @param \ArrayType\ArrayOfJP_SubRating $subRatings
     * @return \StructType\JP_Rating
     */
    public function setSubRatings(\ArrayType\ArrayOfJP_SubRating $subRatings = null)
    {
        $this->SubRatings = $subRatings;
        return $this;
    }
}
