<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ContentProvider StructType
 * @subpackage Structs
 */
class JP_ContentProvider extends AbstractStructBase
{
    /**
     * The Images
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ImageLong
     */
    public $Images;
    /**
     * The MultimediaContents
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_MultimediaContent
     */
    public $MultimediaContents;
    /**
     * The HotelCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelCategory
     */
    public $HotelCategory;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The ExternalCode
     * @var string
     */
    public $ExternalCode;
    /**
     * Constructor method for JP_ContentProvider
     * @uses JP_ContentProvider::setImages()
     * @uses JP_ContentProvider::setMultimediaContents()
     * @uses JP_ContentProvider::setHotelCategory()
     * @uses JP_ContentProvider::setCode()
     * @uses JP_ContentProvider::setExternalCode()
     * @param \ArrayType\ArrayOfJP_ImageLong $images
     * @param \ArrayType\ArrayOfJP_MultimediaContent $multimediaContents
     * @param \StructType\JP_HotelCategory $hotelCategory
     * @param string $code
     * @param string $externalCode
     */
    public function __construct(\ArrayType\ArrayOfJP_ImageLong $images = null, \ArrayType\ArrayOfJP_MultimediaContent $multimediaContents = null, \StructType\JP_HotelCategory $hotelCategory = null, $code = null, $externalCode = null)
    {
        $this
            ->setImages($images)
            ->setMultimediaContents($multimediaContents)
            ->setHotelCategory($hotelCategory)
            ->setCode($code)
            ->setExternalCode($externalCode);
    }
    /**
     * Get Images value
     * @return \ArrayType\ArrayOfJP_ImageLong|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \ArrayType\ArrayOfJP_ImageLong $images
     * @return \StructType\JP_ContentProvider
     */
    public function setImages(\ArrayType\ArrayOfJP_ImageLong $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get MultimediaContents value
     * @return \ArrayType\ArrayOfJP_MultimediaContent|null
     */
    public function getMultimediaContents()
    {
        return $this->MultimediaContents;
    }
    /**
     * Set MultimediaContents value
     * @param \ArrayType\ArrayOfJP_MultimediaContent $multimediaContents
     * @return \StructType\JP_ContentProvider
     */
    public function setMultimediaContents(\ArrayType\ArrayOfJP_MultimediaContent $multimediaContents = null)
    {
        $this->MultimediaContents = $multimediaContents;
        return $this;
    }
    /**
     * Get HotelCategory value
     * @return \StructType\JP_HotelCategory|null
     */
    public function getHotelCategory()
    {
        return $this->HotelCategory;
    }
    /**
     * Set HotelCategory value
     * @param \StructType\JP_HotelCategory $hotelCategory
     * @return \StructType\JP_ContentProvider
     */
    public function setHotelCategory(\StructType\JP_HotelCategory $hotelCategory = null)
    {
        $this->HotelCategory = $hotelCategory;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_ContentProvider
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get ExternalCode value
     * @return string|null
     */
    public function getExternalCode()
    {
        return $this->ExternalCode;
    }
    /**
     * Set ExternalCode value
     * @param string $externalCode
     * @return \StructType\JP_ContentProvider
     */
    public function setExternalCode($externalCode = null)
    {
        // validation for constraint: string
        if (!is_null($externalCode) && !is_string($externalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalCode, true), gettype($externalCode)), __LINE__);
        }
        $this->ExternalCode = $externalCode;
        return $this;
    }
}
