<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Compartment StructType
 * @subpackage Structs
 */
class JP_Compartment extends AbstractStructBase
{
    /**
     * The Seats
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Seat
     */
    public $Seats;
    /**
     * The Cabin
     * @var string
     */
    public $Cabin;
    /**
     * Constructor method for JP_Compartment
     * @uses JP_Compartment::setSeats()
     * @uses JP_Compartment::setCabin()
     * @param \ArrayType\ArrayOfJP_Seat $seats
     * @param string $cabin
     */
    public function __construct(\ArrayType\ArrayOfJP_Seat $seats = null, $cabin = null)
    {
        $this
            ->setSeats($seats)
            ->setCabin($cabin);
    }
    /**
     * Get Seats value
     * @return \ArrayType\ArrayOfJP_Seat|null
     */
    public function getSeats()
    {
        return $this->Seats;
    }
    /**
     * Set Seats value
     * @param \ArrayType\ArrayOfJP_Seat $seats
     * @return \StructType\JP_Compartment
     */
    public function setSeats(\ArrayType\ArrayOfJP_Seat $seats = null)
    {
        $this->Seats = $seats;
        return $this;
    }
    /**
     * Get Cabin value
     * @return string|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @param string $cabin
     * @return \StructType\JP_Compartment
     */
    public function setCabin($cabin = null)
    {
        // validation for constraint: string
        if (!is_null($cabin) && !is_string($cabin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabin, true), gettype($cabin)), __LINE__);
        }
        $this->Cabin = $cabin;
        return $this;
    }
}
