<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_Price StructType
 * @subpackage Structs
 */
class JPSOAP_Price extends AbstractStructBase
{
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The Recommended
     * @var float
     */
    public $Recommended;
    /**
     * Constructor method for JPSOAP_Price
     * @uses JPSOAP_Price::setAmount()
     * @uses JPSOAP_Price::setRecommended()
     * @param float $amount
     * @param float $recommended
     */
    public function __construct($amount = null, $recommended = null)
    {
        $this
            ->setAmount($amount)
            ->setRecommended($recommended);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\JPSOAP_Price
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Recommended value
     * @return float|null
     */
    public function getRecommended()
    {
        return $this->Recommended;
    }
    /**
     * Set Recommended value
     * @param float $recommended
     * @return \StructType\JPSOAP_Price
     */
    public function setRecommended($recommended = null)
    {
        // validation for constraint: float
        if (!is_null($recommended) && !(is_float($recommended) || is_numeric($recommended))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($recommended, true), gettype($recommended)), __LINE__);
        }
        $this->Recommended = $recommended;
        return $this;
    }
}
