<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_AgencyStaticData StructType
 * @subpackage Structs
 */
class JP_AgencyStaticData extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Code;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Type;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_PhoneNumber
     */
    public $PhoneNumber;
    /**
     * The OperationCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperationCurrency;
    /**
     * The AgencyGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_AgencyGroup
     */
    public $AgencyGroup;
    /**
     * The Loyalty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Loyalty
     */
    public $Loyalty;
    /**
     * Constructor method for JP_AgencyStaticData
     * @uses JP_AgencyStaticData::setCode()
     * @uses JP_AgencyStaticData::setType()
     * @uses JP_AgencyStaticData::setName()
     * @uses JP_AgencyStaticData::setEmail()
     * @uses JP_AgencyStaticData::setPhoneNumber()
     * @uses JP_AgencyStaticData::setOperationCurrency()
     * @uses JP_AgencyStaticData::setAgencyGroup()
     * @uses JP_AgencyStaticData::setLoyalty()
     * @param int $code
     * @param int $type
     * @param string $name
     * @param string $email
     * @param \StructType\JP_PhoneNumber $phoneNumber
     * @param string $operationCurrency
     * @param \StructType\JP_AgencyGroup $agencyGroup
     * @param \StructType\JP_Loyalty $loyalty
     */
    public function __construct($code = null, $type = null, $name = null, $email = null, \StructType\JP_PhoneNumber $phoneNumber = null, $operationCurrency = null, \StructType\JP_AgencyGroup $agencyGroup = null, \StructType\JP_Loyalty $loyalty = null)
    {
        $this
            ->setCode($code)
            ->setType($type)
            ->setName($name)
            ->setEmail($email)
            ->setPhoneNumber($phoneNumber)
            ->setOperationCurrency($operationCurrency)
            ->setAgencyGroup($agencyGroup)
            ->setLoyalty($loyalty);
    }
    /**
     * Get Code value
     * @return int
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\JP_AgencyStaticData
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Type value
     * @return int
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param int $type
     * @return \StructType\JP_AgencyStaticData
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_AgencyStaticData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\JP_AgencyStaticData
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return \StructType\JP_PhoneNumber|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param \StructType\JP_PhoneNumber $phoneNumber
     * @return \StructType\JP_AgencyStaticData
     */
    public function setPhoneNumber(\StructType\JP_PhoneNumber $phoneNumber = null)
    {
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get OperationCurrency value
     * @return string|null
     */
    public function getOperationCurrency()
    {
        return $this->OperationCurrency;
    }
    /**
     * Set OperationCurrency value
     * @param string $operationCurrency
     * @return \StructType\JP_AgencyStaticData
     */
    public function setOperationCurrency($operationCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($operationCurrency) && !is_string($operationCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationCurrency, true), gettype($operationCurrency)), __LINE__);
        }
        $this->OperationCurrency = $operationCurrency;
        return $this;
    }
    /**
     * Get AgencyGroup value
     * @return \StructType\JP_AgencyGroup|null
     */
    public function getAgencyGroup()
    {
        return $this->AgencyGroup;
    }
    /**
     * Set AgencyGroup value
     * @param \StructType\JP_AgencyGroup $agencyGroup
     * @return \StructType\JP_AgencyStaticData
     */
    public function setAgencyGroup(\StructType\JP_AgencyGroup $agencyGroup = null)
    {
        $this->AgencyGroup = $agencyGroup;
        return $this;
    }
    /**
     * Get Loyalty value
     * @return \StructType\JP_Loyalty|null
     */
    public function getLoyalty()
    {
        return $this->Loyalty;
    }
    /**
     * Set Loyalty value
     * @param \StructType\JP_Loyalty $loyalty
     * @return \StructType\JP_AgencyStaticData
     */
    public function setLoyalty(\StructType\JP_Loyalty $loyalty = null)
    {
        $this->Loyalty = $loyalty;
        return $this;
    }
}
