<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Supplier ServiceType
 * @subpackage Services
 */
class Supplier extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SupplierList
     * Meta information extracted from the WSDL
     * - documentation: Generic Supplier List
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SupplierList $parameters
     * @return \StructType\SupplierListResponse|bool
     */
    public function SupplierList(\StructType\SupplierList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SupplierList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SupplierListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
