<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString8 ArrayType
 * @subpackage Arrays
 */
class ArrayOfString8 extends AbstractStructArrayBase
{
    /**
     * The PackageCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PackageCode;
    /**
     * Constructor method for ArrayOfString8
     * @uses ArrayOfString8::setPackageCode()
     * @param string[] $packageCode
     */
    public function __construct(array $packageCode = array())
    {
        $this
            ->setPackageCode($packageCode);
    }
    /**
     * Get PackageCode value
     * @return string[]|null
     */
    public function getPackageCode()
    {
        return $this->PackageCode;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageCodeForArrayConstraintsFromSetPackageCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfString8PackageCodeItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString8PackageCodeItem)) {
                $invalidValues[] = is_object($arrayOfString8PackageCodeItem) ? get_class($arrayOfString8PackageCodeItem) : sprintf('%s(%s)', gettype($arrayOfString8PackageCodeItem), var_export($arrayOfString8PackageCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackageCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PackageCode value
     * @throws \InvalidArgumentException
     * @param string[] $packageCode
     * @return \ArrayType\ArrayOfString8
     */
    public function setPackageCode(array $packageCode = array())
    {
        // validation for constraint: array
        if ('' !== ($packageCodeArrayErrorMessage = self::validatePackageCodeForArrayConstraintsFromSetPackageCode($packageCode))) {
            throw new \InvalidArgumentException($packageCodeArrayErrorMessage, __LINE__);
        }
        $this->PackageCode = $packageCode;
        return $this;
    }
    /**
     * Add item to PackageCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString8
     */
    public function addToPackageCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PackageCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackageCode[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PackageCode
     */
    public function getAttributeName()
    {
        return 'PackageCode';
    }
}
