<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Loyalty StructType
 * @subpackage Structs
 */
class JP_Loyalty extends AbstractStructBase
{
    /**
     * The TotalValue
     * Meta information extracted from the WSDL
     * - use: required
     * @var float
     */
    public $TotalValue;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * Constructor method for JP_Loyalty
     * @uses JP_Loyalty::setTotalValue()
     * @uses JP_Loyalty::setReference()
     * @param float $totalValue
     * @param string $reference
     */
    public function __construct($totalValue = null, $reference = null)
    {
        $this
            ->setTotalValue($totalValue)
            ->setReference($reference);
    }
    /**
     * Get TotalValue value
     * @return float
     */
    public function getTotalValue()
    {
        return $this->TotalValue;
    }
    /**
     * Set TotalValue value
     * @param float $totalValue
     * @return \StructType\JP_Loyalty
     */
    public function setTotalValue($totalValue = null)
    {
        // validation for constraint: float
        if (!is_null($totalValue) && !(is_float($totalValue) || is_numeric($totalValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalValue, true), gettype($totalValue)), __LINE__);
        }
        $this->TotalValue = $totalValue;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\JP_Loyalty
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
}
