<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_InsuranceResult StructType
 * @subpackage Structs
 */
class JP_InsuranceResult extends AbstractStructBase
{
    /**
     * The InsuranceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_InsuranceInfo
     */
    public $InsuranceInfo;
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The DestinationZone
     * @var string
     */
    public $DestinationZone;
    /**
     * The OriginZone
     * @var string
     */
    public $OriginZone;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * Constructor method for JP_InsuranceResult
     * @uses JP_InsuranceResult::setInsuranceInfo()
     * @uses JP_InsuranceResult::setPrices()
     * @uses JP_InsuranceResult::setCode()
     * @uses JP_InsuranceResult::setDestinationZone()
     * @uses JP_InsuranceResult::setOriginZone()
     * @uses JP_InsuranceResult::setRatePlanCode()
     * @uses JP_InsuranceResult::setStatus()
     * @param \StructType\JP_InsuranceInfo $insuranceInfo
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param string $code
     * @param string $destinationZone
     * @param string $originZone
     * @param string $ratePlanCode
     * @param string $status
     */
    public function __construct(\StructType\JP_InsuranceInfo $insuranceInfo = null, \ArrayType\ArrayOfJP_Price $prices = null, $code = null, $destinationZone = null, $originZone = null, $ratePlanCode = null, $status = null)
    {
        $this
            ->setInsuranceInfo($insuranceInfo)
            ->setPrices($prices)
            ->setCode($code)
            ->setDestinationZone($destinationZone)
            ->setOriginZone($originZone)
            ->setRatePlanCode($ratePlanCode)
            ->setStatus($status);
    }
    /**
     * Get InsuranceInfo value
     * @return \StructType\JP_InsuranceInfo|null
     */
    public function getInsuranceInfo()
    {
        return $this->InsuranceInfo;
    }
    /**
     * Set InsuranceInfo value
     * @param \StructType\JP_InsuranceInfo $insuranceInfo
     * @return \StructType\JP_InsuranceResult
     */
    public function setInsuranceInfo(\StructType\JP_InsuranceInfo $insuranceInfo = null)
    {
        $this->InsuranceInfo = $insuranceInfo;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_InsuranceResult
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_InsuranceResult
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get DestinationZone value
     * @return string|null
     */
    public function getDestinationZone()
    {
        return $this->DestinationZone;
    }
    /**
     * Set DestinationZone value
     * @param string $destinationZone
     * @return \StructType\JP_InsuranceResult
     */
    public function setDestinationZone($destinationZone = null)
    {
        // validation for constraint: string
        if (!is_null($destinationZone) && !is_string($destinationZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationZone, true), gettype($destinationZone)), __LINE__);
        }
        $this->DestinationZone = $destinationZone;
        return $this;
    }
    /**
     * Get OriginZone value
     * @return string|null
     */
    public function getOriginZone()
    {
        return $this->OriginZone;
    }
    /**
     * Set OriginZone value
     * @param string $originZone
     * @return \StructType\JP_InsuranceResult
     */
    public function setOriginZone($originZone = null)
    {
        // validation for constraint: string
        if (!is_null($originZone) && !is_string($originZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originZone, true), gettype($originZone)), __LINE__);
        }
        $this->OriginZone = $originZone;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_InsuranceResult
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_InsuranceResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_AvailStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
