<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_OrderedPrice StructType
 * @subpackage Structs
 */
class JPSOAP_OrderedPrice extends JPSOAP_Price
{
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Order;
    /**
     * Constructor method for JPSOAP_OrderedPrice
     * @uses JPSOAP_OrderedPrice::setOrder()
     * @param int $order
     */
    public function __construct($order = null)
    {
        $this
            ->setOrder($order);
    }
    /**
     * Get Order value
     * @return int
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\JPSOAP_OrderedPrice
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
}
