<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cruise ServiceType
 * @subpackage Services
 */
class Cruise extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CruiseBooking
     * Meta information extracted from the WSDL
     * - documentation: Booking for cruises.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CruiseBooking $parameters
     * @return \StructType\CruiseBookingResponse|bool
     */
    public function CruiseBooking(\StructType\CruiseBooking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CruiseBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CruisePreAvail
     * Meta information extracted from the WSDL
     * - documentation: Pre-Availability for cruises.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CruisePreAvail $parameters
     * @return \StructType\CruisePreAvailResponse|bool
     */
    public function CruisePreAvail(\StructType\CruisePreAvail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CruisePreAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CruiseAvail
     * Meta information extracted from the WSDL
     * - documentation: Availability for cruises.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CruiseAvail $parameters
     * @return \StructType\CruiseAvailResponse|bool
     */
    public function CruiseAvail(\StructType\CruiseAvail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CruiseAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CruiseItinerary
     * Meta information extracted from the WSDL
     * - documentation: List of itineraries.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CruiseItinerary $parameters
     * @return \StructType\CruiseItineraryResponse|bool
     */
    public function CruiseItinerary(\StructType\CruiseItinerary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CruiseItinerary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CruiseShip
     * Meta information extracted from the WSDL
     * - documentation: List of ships.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CruiseShip $parameters
     * @return \StructType\CruiseShipResponse|bool
     */
    public function CruiseShip(\StructType\CruiseShip $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CruiseShip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CruiseDataList
     * Meta information extracted from the WSDL
     * - documentation: List of Cruises Data.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CruiseDataList $parameters
     * @return \StructType\CruiseDataListResponse|bool
     */
    public function CruiseDataList(\StructType\CruiseDataList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CruiseDataList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CruiseCheckAvail
     * Meta information extracted from the WSDL
     * - documentation: CheckAvail for cruises.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CruiseCheckAvail $parameters
     * @return \StructType\CruiseCheckAvailResponse|bool
     */
    public function CruiseCheckAvail(\StructType\CruiseCheckAvail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CruiseCheckAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CruiseBookingRules
     * Meta information extracted from the WSDL
     * - documentation: BookingRules of cruises.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CruiseBookingRules $parameters
     * @return \StructType\CruiseBookingRulesResponse|bool
     */
    public function CruiseBookingRules(\StructType\CruiseBookingRules $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CruiseBookingRules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CruiseAvailResponse|\StructType\CruiseBookingResponse|\StructType\CruiseBookingRulesResponse|\StructType\CruiseCheckAvailResponse|\StructType\CruiseDataListResponse|\StructType\CruiseItineraryResponse|\StructType\CruisePreAvailResponse|\StructType\CruiseShipResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
