<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ZoneListRequest StructType
 * @subpackage Structs
 */
class JP_ZoneListRequest extends AbstractStructBase
{
    /**
     * The ProductType
     * @var string
     */
    public $ProductType;
    /**
     * The ShowIATA
     * @var bool
     */
    public $ShowIATA;
    /**
     * The MaxLevel
     * @var int
     */
    public $MaxLevel;
    /**
     * Constructor method for JP_ZoneListRequest
     * @uses JP_ZoneListRequest::setProductType()
     * @uses JP_ZoneListRequest::setShowIATA()
     * @uses JP_ZoneListRequest::setMaxLevel()
     * @param string $productType
     * @param bool $showIATA
     * @param int $maxLevel
     */
    public function __construct($productType = null, $showIATA = null, $maxLevel = null)
    {
        $this
            ->setProductType($productType)
            ->setShowIATA($showIATA)
            ->setMaxLevel($maxLevel);
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @uses \EnumType\JP_ProductType::valueIsValid()
     * @uses \EnumType\JP_ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \StructType\JP_ZoneListRequest
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_ProductType::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_ProductType', is_array($productType) ? implode(', ', $productType) : var_export($productType, true), implode(', ', \EnumType\JP_ProductType::getValidValues())), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get ShowIATA value
     * @return bool|null
     */
    public function getShowIATA()
    {
        return $this->ShowIATA;
    }
    /**
     * Set ShowIATA value
     * @param bool $showIATA
     * @return \StructType\JP_ZoneListRequest
     */
    public function setShowIATA($showIATA = null)
    {
        // validation for constraint: boolean
        if (!is_null($showIATA) && !is_bool($showIATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showIATA, true), gettype($showIATA)), __LINE__);
        }
        $this->ShowIATA = $showIATA;
        return $this;
    }
    /**
     * Get MaxLevel value
     * @return int|null
     */
    public function getMaxLevel()
    {
        return $this->MaxLevel;
    }
    /**
     * Set MaxLevel value
     * @param int $maxLevel
     * @return \StructType\JP_ZoneListRequest
     */
    public function setMaxLevel($maxLevel = null)
    {
        // validation for constraint: int
        if (!is_null($maxLevel) && !(is_int($maxLevel) || ctype_digit($maxLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxLevel, true), gettype($maxLevel)), __LINE__);
        }
        $this->MaxLevel = $maxLevel;
        return $this;
    }
}
