<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TransferBookingInfo StructType
 * @subpackage Structs
 */
class JP_TransferBookingInfo extends AbstractStructBase
{
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransferOrigin
     */
    public $Origin;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransferDestination
     */
    public $Destination;
    /**
     * The HotelService
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelService
     */
    public $HotelService;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Language
     */
    public $Language;
    /**
     * The AdditionalRequiredFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_AdditionalRequiredField
     */
    public $AdditionalRequiredFields;
    /**
     * The ICode
     * @var string
     */
    public $ICode;
    /**
     * The Route
     * @var string
     */
    public $Route;
    /**
     * Constructor method for JP_TransferBookingInfo
     * @uses JP_TransferBookingInfo::setOrigin()
     * @uses JP_TransferBookingInfo::setDestination()
     * @uses JP_TransferBookingInfo::setHotelService()
     * @uses JP_TransferBookingInfo::setLanguage()
     * @uses JP_TransferBookingInfo::setAdditionalRequiredFields()
     * @uses JP_TransferBookingInfo::setICode()
     * @uses JP_TransferBookingInfo::setRoute()
     * @param \StructType\JP_TransferOrigin $origin
     * @param \StructType\JP_TransferDestination $destination
     * @param \StructType\JP_HotelService $hotelService
     * @param \StructType\JP_Language $language
     * @param \ArrayType\ArrayOfJP_AdditionalRequiredField $additionalRequiredFields
     * @param string $iCode
     * @param string $route
     */
    public function __construct(\StructType\JP_TransferOrigin $origin = null, \StructType\JP_TransferDestination $destination = null, \StructType\JP_HotelService $hotelService = null, \StructType\JP_Language $language = null, \ArrayType\ArrayOfJP_AdditionalRequiredField $additionalRequiredFields = null, $iCode = null, $route = null)
    {
        $this
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setHotelService($hotelService)
            ->setLanguage($language)
            ->setAdditionalRequiredFields($additionalRequiredFields)
            ->setICode($iCode)
            ->setRoute($route);
    }
    /**
     * Get Origin value
     * @return \StructType\JP_TransferOrigin|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param \StructType\JP_TransferOrigin $origin
     * @return \StructType\JP_TransferBookingInfo
     */
    public function setOrigin(\StructType\JP_TransferOrigin $origin = null)
    {
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return \StructType\JP_TransferDestination|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param \StructType\JP_TransferDestination $destination
     * @return \StructType\JP_TransferBookingInfo
     */
    public function setDestination(\StructType\JP_TransferDestination $destination = null)
    {
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get HotelService value
     * @return \StructType\JP_HotelService|null
     */
    public function getHotelService()
    {
        return $this->HotelService;
    }
    /**
     * Set HotelService value
     * @param \StructType\JP_HotelService $hotelService
     * @return \StructType\JP_TransferBookingInfo
     */
    public function setHotelService(\StructType\JP_HotelService $hotelService = null)
    {
        $this->HotelService = $hotelService;
        return $this;
    }
    /**
     * Get Language value
     * @return \StructType\JP_Language|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param \StructType\JP_Language $language
     * @return \StructType\JP_TransferBookingInfo
     */
    public function setLanguage(\StructType\JP_Language $language = null)
    {
        $this->Language = $language;
        return $this;
    }
    /**
     * Get AdditionalRequiredFields value
     * @return \ArrayType\ArrayOfJP_AdditionalRequiredField|null
     */
    public function getAdditionalRequiredFields()
    {
        return $this->AdditionalRequiredFields;
    }
    /**
     * Set AdditionalRequiredFields value
     * @param \ArrayType\ArrayOfJP_AdditionalRequiredField $additionalRequiredFields
     * @return \StructType\JP_TransferBookingInfo
     */
    public function setAdditionalRequiredFields(\ArrayType\ArrayOfJP_AdditionalRequiredField $additionalRequiredFields = null)
    {
        $this->AdditionalRequiredFields = $additionalRequiredFields;
        return $this;
    }
    /**
     * Get ICode value
     * @return string|null
     */
    public function getICode()
    {
        return $this->ICode;
    }
    /**
     * Set ICode value
     * @param string $iCode
     * @return \StructType\JP_TransferBookingInfo
     */
    public function setICode($iCode = null)
    {
        // validation for constraint: string
        if (!is_null($iCode) && !is_string($iCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iCode, true), gettype($iCode)), __LINE__);
        }
        $this->ICode = $iCode;
        return $this;
    }
    /**
     * Get Route value
     * @return string|null
     */
    public function getRoute()
    {
        return $this->Route;
    }
    /**
     * Set Route value
     * @uses \EnumType\JP_RouteType::valueIsValid()
     * @uses \EnumType\JP_RouteType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $route
     * @return \StructType\JP_TransferBookingInfo
     */
    public function setRoute($route = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_RouteType::valueIsValid($route)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_RouteType', is_array($route) ? implode(', ', $route) : var_export($route, true), implode(', ', \EnumType\JP_RouteType::getValidValues())), __LINE__);
        }
        $this->Route = $route;
        return $this;
    }
}
