<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceResult StructType
 * @subpackage Structs
 */
class JP_ServiceResult extends AbstractStructBase
{
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The DestinationZone
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $DestinationZone;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The HasAdditionalRequiredFields
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $HasAdditionalRequiredFields;
    /**
     * The ServiceInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ServiceInfo
     */
    public $ServiceInfo;
    /**
     * The ServiceOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ServiceOption
     */
    public $ServiceOptions;
    /**
     * The AdditionalRequiredFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_AdditionalRequiredField
     */
    public $AdditionalRequiredFields;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * Constructor method for JP_ServiceResult
     * @uses JP_ServiceResult::setStart()
     * @uses JP_ServiceResult::setEnd()
     * @uses JP_ServiceResult::setDestinationZone()
     * @uses JP_ServiceResult::setStatus()
     * @uses JP_ServiceResult::setHasAdditionalRequiredFields()
     * @uses JP_ServiceResult::setServiceInfo()
     * @uses JP_ServiceResult::setServiceOptions()
     * @uses JP_ServiceResult::setAdditionalRequiredFields()
     * @uses JP_ServiceResult::setCode()
     * @uses JP_ServiceResult::setOrder()
     * @param string $start
     * @param string $end
     * @param int $destinationZone
     * @param string $status
     * @param bool $hasAdditionalRequiredFields
     * @param \StructType\JP_ServiceInfo $serviceInfo
     * @param \ArrayType\ArrayOfJP_ServiceOption $serviceOptions
     * @param \ArrayType\ArrayOfJP_AdditionalRequiredField $additionalRequiredFields
     * @param string $code
     * @param int $order
     */
    public function __construct($start = null, $end = null, $destinationZone = null, $status = null, $hasAdditionalRequiredFields = null, \StructType\JP_ServiceInfo $serviceInfo = null, \ArrayType\ArrayOfJP_ServiceOption $serviceOptions = null, \ArrayType\ArrayOfJP_AdditionalRequiredField $additionalRequiredFields = null, $code = null, $order = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setDestinationZone($destinationZone)
            ->setStatus($status)
            ->setHasAdditionalRequiredFields($hasAdditionalRequiredFields)
            ->setServiceInfo($serviceInfo)
            ->setServiceOptions($serviceOptions)
            ->setAdditionalRequiredFields($additionalRequiredFields)
            ->setCode($code)
            ->setOrder($order);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_ServiceResult
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_ServiceResult
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get DestinationZone value
     * @return int
     */
    public function getDestinationZone()
    {
        return $this->DestinationZone;
    }
    /**
     * Set DestinationZone value
     * @param int $destinationZone
     * @return \StructType\JP_ServiceResult
     */
    public function setDestinationZone($destinationZone = null)
    {
        // validation for constraint: int
        if (!is_null($destinationZone) && !(is_int($destinationZone) || ctype_digit($destinationZone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($destinationZone, true), gettype($destinationZone)), __LINE__);
        }
        $this->DestinationZone = $destinationZone;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_ServiceResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_AvailStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get HasAdditionalRequiredFields value
     * @return bool
     */
    public function getHasAdditionalRequiredFields()
    {
        return $this->HasAdditionalRequiredFields;
    }
    /**
     * Set HasAdditionalRequiredFields value
     * @param bool $hasAdditionalRequiredFields
     * @return \StructType\JP_ServiceResult
     */
    public function setHasAdditionalRequiredFields($hasAdditionalRequiredFields = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasAdditionalRequiredFields) && !is_bool($hasAdditionalRequiredFields)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasAdditionalRequiredFields, true), gettype($hasAdditionalRequiredFields)), __LINE__);
        }
        $this->HasAdditionalRequiredFields = $hasAdditionalRequiredFields;
        return $this;
    }
    /**
     * Get ServiceInfo value
     * @return \StructType\JP_ServiceInfo|null
     */
    public function getServiceInfo()
    {
        return $this->ServiceInfo;
    }
    /**
     * Set ServiceInfo value
     * @param \StructType\JP_ServiceInfo $serviceInfo
     * @return \StructType\JP_ServiceResult
     */
    public function setServiceInfo(\StructType\JP_ServiceInfo $serviceInfo = null)
    {
        $this->ServiceInfo = $serviceInfo;
        return $this;
    }
    /**
     * Get ServiceOptions value
     * @return \ArrayType\ArrayOfJP_ServiceOption|null
     */
    public function getServiceOptions()
    {
        return $this->ServiceOptions;
    }
    /**
     * Set ServiceOptions value
     * @param \ArrayType\ArrayOfJP_ServiceOption $serviceOptions
     * @return \StructType\JP_ServiceResult
     */
    public function setServiceOptions(\ArrayType\ArrayOfJP_ServiceOption $serviceOptions = null)
    {
        $this->ServiceOptions = $serviceOptions;
        return $this;
    }
    /**
     * Get AdditionalRequiredFields value
     * @return \ArrayType\ArrayOfJP_AdditionalRequiredField|null
     */
    public function getAdditionalRequiredFields()
    {
        return $this->AdditionalRequiredFields;
    }
    /**
     * Set AdditionalRequiredFields value
     * @param \ArrayType\ArrayOfJP_AdditionalRequiredField $additionalRequiredFields
     * @return \StructType\JP_ServiceResult
     */
    public function setAdditionalRequiredFields(\ArrayType\ArrayOfJP_AdditionalRequiredField $additionalRequiredFields = null)
    {
        $this->AdditionalRequiredFields = $additionalRequiredFields;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_ServiceResult
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\JP_ServiceResult
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
}
