<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Seat StructType
 * @subpackage Structs
 */
class JP_Seat extends AbstractStructBase
{
    /**
     * The Group
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Group;
    /**
     * The Premium
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Premium;
    /**
     * The Situations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString5
     */
    public $Situations;
    /**
     * The Avail
     * @var string
     */
    public $Avail;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The SeatSelectionCode
     * @var string
     */
    public $SeatSelectionCode;
    /**
     * Constructor method for JP_Seat
     * @uses JP_Seat::setGroup()
     * @uses JP_Seat::setPremium()
     * @uses JP_Seat::setSituations()
     * @uses JP_Seat::setAvail()
     * @uses JP_Seat::setCode()
     * @uses JP_Seat::setSeatSelectionCode()
     * @param int $group
     * @param bool $premium
     * @param \ArrayType\ArrayOfString5 $situations
     * @param string $avail
     * @param string $code
     * @param string $seatSelectionCode
     */
    public function __construct($group = null, $premium = null, \ArrayType\ArrayOfString5 $situations = null, $avail = null, $code = null, $seatSelectionCode = null)
    {
        $this
            ->setGroup($group)
            ->setPremium($premium)
            ->setSituations($situations)
            ->setAvail($avail)
            ->setCode($code)
            ->setSeatSelectionCode($seatSelectionCode);
    }
    /**
     * Get Group value
     * @return int
     */
    public function getGroup()
    {
        return $this->Group;
    }
    /**
     * Set Group value
     * @param int $group
     * @return \StructType\JP_Seat
     */
    public function setGroup($group = null)
    {
        // validation for constraint: int
        if (!is_null($group) && !(is_int($group) || ctype_digit($group))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($group, true), gettype($group)), __LINE__);
        }
        $this->Group = $group;
        return $this;
    }
    /**
     * Get Premium value
     * @return bool
     */
    public function getPremium()
    {
        return $this->Premium;
    }
    /**
     * Set Premium value
     * @param bool $premium
     * @return \StructType\JP_Seat
     */
    public function setPremium($premium = null)
    {
        // validation for constraint: boolean
        if (!is_null($premium) && !is_bool($premium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($premium, true), gettype($premium)), __LINE__);
        }
        $this->Premium = $premium;
        return $this;
    }
    /**
     * Get Situations value
     * @return \ArrayType\ArrayOfString5|null
     */
    public function getSituations()
    {
        return $this->Situations;
    }
    /**
     * Set Situations value
     * @param \ArrayType\ArrayOfString5 $situations
     * @return \StructType\JP_Seat
     */
    public function setSituations(\ArrayType\ArrayOfString5 $situations = null)
    {
        $this->Situations = $situations;
        return $this;
    }
    /**
     * Get Avail value
     * @return string|null
     */
    public function getAvail()
    {
        return $this->Avail;
    }
    /**
     * Set Avail value
     * @param string $avail
     * @return \StructType\JP_Seat
     */
    public function setAvail($avail = null)
    {
        // validation for constraint: string
        if (!is_null($avail) && !is_string($avail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($avail, true), gettype($avail)), __LINE__);
        }
        $this->Avail = $avail;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_Seat
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get SeatSelectionCode value
     * @return string|null
     */
    public function getSeatSelectionCode()
    {
        return $this->SeatSelectionCode;
    }
    /**
     * Set SeatSelectionCode value
     * @param string $seatSelectionCode
     * @return \StructType\JP_Seat
     */
    public function setSeatSelectionCode($seatSelectionCode = null)
    {
        // validation for constraint: string
        if (!is_null($seatSelectionCode) && !is_string($seatSelectionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatSelectionCode, true), gettype($seatSelectionCode)), __LINE__);
        }
        $this->SeatSelectionCode = $seatSelectionCode;
        return $this;
    }
}
