<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_InsuranceCheckAvail StructType
 * @subpackage Structs
 */
class JP_InsuranceCheckAvail extends AbstractStructBase
{
    /**
     * The Login
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The InsuranceCheckAvailRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_InsuranceCheckAvailRequest
     */
    public $InsuranceCheckAvailRequest;
    /**
     * The AdvancedOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_InsuranceCheckAvailAdvancedOptions
     */
    public $AdvancedOptions;
    /**
     * The RestrictedOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * Constructor method for JP_InsuranceCheckAvail
     * @uses JP_InsuranceCheckAvail::setLogin()
     * @uses JP_InsuranceCheckAvail::setInsuranceCheckAvailRequest()
     * @uses JP_InsuranceCheckAvail::setAdvancedOptions()
     * @uses JP_InsuranceCheckAvail::setRestrictedOptions()
     * @uses JP_InsuranceCheckAvail::setVersion()
     * @uses JP_InsuranceCheckAvail::setLanguage()
     * @uses JP_InsuranceCheckAvail::setTimeStamp()
     * @param \StructType\JP_Login $login
     * @param \StructType\JP_InsuranceCheckAvailRequest $insuranceCheckAvailRequest
     * @param \StructType\JP_InsuranceCheckAvailAdvancedOptions $advancedOptions
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param string $version
     * @param string $language
     * @param string $timeStamp
     */
    public function __construct(\StructType\JP_Login $login = null, \StructType\JP_InsuranceCheckAvailRequest $insuranceCheckAvailRequest = null, \StructType\JP_InsuranceCheckAvailAdvancedOptions $advancedOptions = null, \StructType\JP_RestrictedOptions $restrictedOptions = null, $version = null, $language = null, $timeStamp = null)
    {
        $this
            ->setLogin($login)
            ->setInsuranceCheckAvailRequest($insuranceCheckAvailRequest)
            ->setAdvancedOptions($advancedOptions)
            ->setRestrictedOptions($restrictedOptions)
            ->setVersion($version)
            ->setLanguage($language)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_InsuranceCheckAvail
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get InsuranceCheckAvailRequest value
     * @return \StructType\JP_InsuranceCheckAvailRequest|null
     */
    public function getInsuranceCheckAvailRequest()
    {
        return $this->InsuranceCheckAvailRequest;
    }
    /**
     * Set InsuranceCheckAvailRequest value
     * @param \StructType\JP_InsuranceCheckAvailRequest $insuranceCheckAvailRequest
     * @return \StructType\JP_InsuranceCheckAvail
     */
    public function setInsuranceCheckAvailRequest(\StructType\JP_InsuranceCheckAvailRequest $insuranceCheckAvailRequest = null)
    {
        $this->InsuranceCheckAvailRequest = $insuranceCheckAvailRequest;
        return $this;
    }
    /**
     * Get AdvancedOptions value
     * @return \StructType\JP_InsuranceCheckAvailAdvancedOptions|null
     */
    public function getAdvancedOptions()
    {
        return $this->AdvancedOptions;
    }
    /**
     * Set AdvancedOptions value
     * @param \StructType\JP_InsuranceCheckAvailAdvancedOptions $advancedOptions
     * @return \StructType\JP_InsuranceCheckAvail
     */
    public function setAdvancedOptions(\StructType\JP_InsuranceCheckAvailAdvancedOptions $advancedOptions = null)
    {
        $this->AdvancedOptions = $advancedOptions;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_InsuranceCheckAvail
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_InsuranceCheckAvail
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_InsuranceCheckAvail
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\JP_InsuranceCheckAvail
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
}
