<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelFutureRatesAdvancedOptions StructType
 * @subpackage Structs
 */
class JP_HotelFutureRatesAdvancedOptions extends JP_HotelAvailAdvancedOptions
{
    /**
     * The BookingDay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BookingDay;
    /**
     * The ApplicationOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApplicationOptions
     */
    public $ApplicationOptions;
    /**
     * Constructor method for JP_HotelFutureRatesAdvancedOptions
     * @uses JP_HotelFutureRatesAdvancedOptions::setBookingDay()
     * @uses JP_HotelFutureRatesAdvancedOptions::setApplicationOptions()
     * @param string $bookingDay
     * @param \StructType\ApplicationOptions $applicationOptions
     */
    public function __construct($bookingDay = null, \StructType\ApplicationOptions $applicationOptions = null)
    {
        $this
            ->setBookingDay($bookingDay)
            ->setApplicationOptions($applicationOptions);
    }
    /**
     * Get BookingDay value
     * @return string|null
     */
    public function getBookingDay()
    {
        return $this->BookingDay;
    }
    /**
     * Set BookingDay value
     * @param string $bookingDay
     * @return \StructType\JP_HotelFutureRatesAdvancedOptions
     */
    public function setBookingDay($bookingDay = null)
    {
        // validation for constraint: string
        if (!is_null($bookingDay) && !is_string($bookingDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingDay, true), gettype($bookingDay)), __LINE__);
        }
        $this->BookingDay = $bookingDay;
        return $this;
    }
    /**
     * Get ApplicationOptions value
     * @return \StructType\ApplicationOptions|null
     */
    public function getApplicationOptions()
    {
        return $this->ApplicationOptions;
    }
    /**
     * Set ApplicationOptions value
     * @param \StructType\ApplicationOptions $applicationOptions
     * @return \StructType\JP_HotelFutureRatesAdvancedOptions
     */
    public function setApplicationOptions(\StructType\ApplicationOptions $applicationOptions = null)
    {
        $this->ApplicationOptions = $applicationOptions;
        return $this;
    }
}
