<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ExternalZone StructType
 * @subpackage Structs
 */
class JP_ExternalZone extends AbstractStructBase
{
    /**
     * The IATA
     * @var string
     */
    public $IATA;
    /**
     * The ISO2
     * @var string
     */
    public $ISO2;
    /**
     * Constructor method for JP_ExternalZone
     * @uses JP_ExternalZone::setIATA()
     * @uses JP_ExternalZone::setISO2()
     * @param string $iATA
     * @param string $iSO2
     */
    public function __construct($iATA = null, $iSO2 = null)
    {
        $this
            ->setIATA($iATA)
            ->setISO2($iSO2);
    }
    /**
     * Get IATA value
     * @return string|null
     */
    public function getIATA()
    {
        return $this->IATA;
    }
    /**
     * Set IATA value
     * @param string $iATA
     * @return \StructType\JP_ExternalZone
     */
    public function setIATA($iATA = null)
    {
        // validation for constraint: string
        if (!is_null($iATA) && !is_string($iATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATA, true), gettype($iATA)), __LINE__);
        }
        $this->IATA = $iATA;
        return $this;
    }
    /**
     * Get ISO2 value
     * @return string|null
     */
    public function getISO2()
    {
        return $this->ISO2;
    }
    /**
     * Set ISO2 value
     * @param string $iSO2
     * @return \StructType\JP_ExternalZone
     */
    public function setISO2($iSO2 = null)
    {
        // validation for constraint: string
        if (!is_null($iSO2) && !is_string($iSO2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iSO2, true), gettype($iSO2)), __LINE__);
        }
        $this->ISO2 = $iSO2;
        return $this;
    }
}
