<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_RatePrice StructType
 * @subpackage Structs
 */
class JPSOAP_RatePrice extends AbstractStructBase
{
    /**
     * The BoardCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $BoardCode;
    /**
     * The RoomTypeCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $RoomTypeCode;
    /**
     * The Adult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_Price
     */
    public $Adult;
    /**
     * The Room
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_Price
     */
    public $Room;
    /**
     * The AdultAdditionals
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJPSOAP_OrderedPrice
     */
    public $AdultAdditionals;
    /**
     * The ChildrenA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJPSOAP_OrderedPrice1
     */
    public $ChildrenA;
    /**
     * The ChildrenB
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJPSOAP_OrderedPrice2
     */
    public $ChildrenB;
    /**
     * The ChildrenC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJPSOAP_OrderedPrice3
     */
    public $ChildrenC;
    /**
     * Constructor method for JPSOAP_RatePrice
     * @uses JPSOAP_RatePrice::setBoardCode()
     * @uses JPSOAP_RatePrice::setRoomTypeCode()
     * @uses JPSOAP_RatePrice::setAdult()
     * @uses JPSOAP_RatePrice::setRoom()
     * @uses JPSOAP_RatePrice::setAdultAdditionals()
     * @uses JPSOAP_RatePrice::setChildrenA()
     * @uses JPSOAP_RatePrice::setChildrenB()
     * @uses JPSOAP_RatePrice::setChildrenC()
     * @param int $boardCode
     * @param int $roomTypeCode
     * @param \StructType\JPSOAP_Price $adult
     * @param \StructType\JPSOAP_Price $room
     * @param \ArrayType\ArrayOfJPSOAP_OrderedPrice $adultAdditionals
     * @param \ArrayType\ArrayOfJPSOAP_OrderedPrice1 $childrenA
     * @param \ArrayType\ArrayOfJPSOAP_OrderedPrice2 $childrenB
     * @param \ArrayType\ArrayOfJPSOAP_OrderedPrice3 $childrenC
     */
    public function __construct($boardCode = null, $roomTypeCode = null, \StructType\JPSOAP_Price $adult = null, \StructType\JPSOAP_Price $room = null, \ArrayType\ArrayOfJPSOAP_OrderedPrice $adultAdditionals = null, \ArrayType\ArrayOfJPSOAP_OrderedPrice1 $childrenA = null, \ArrayType\ArrayOfJPSOAP_OrderedPrice2 $childrenB = null, \ArrayType\ArrayOfJPSOAP_OrderedPrice3 $childrenC = null)
    {
        $this
            ->setBoardCode($boardCode)
            ->setRoomTypeCode($roomTypeCode)
            ->setAdult($adult)
            ->setRoom($room)
            ->setAdultAdditionals($adultAdditionals)
            ->setChildrenA($childrenA)
            ->setChildrenB($childrenB)
            ->setChildrenC($childrenC);
    }
    /**
     * Get BoardCode value
     * @return int
     */
    public function getBoardCode()
    {
        return $this->BoardCode;
    }
    /**
     * Set BoardCode value
     * @param int $boardCode
     * @return \StructType\JPSOAP_RatePrice
     */
    public function setBoardCode($boardCode = null)
    {
        // validation for constraint: int
        if (!is_null($boardCode) && !(is_int($boardCode) || ctype_digit($boardCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($boardCode, true), gettype($boardCode)), __LINE__);
        }
        $this->BoardCode = $boardCode;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return int
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param int $roomTypeCode
     * @return \StructType\JPSOAP_RatePrice
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: int
        if (!is_null($roomTypeCode) && !(is_int($roomTypeCode) || ctype_digit($roomTypeCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get Adult value
     * @return \StructType\JPSOAP_Price|null
     */
    public function getAdult()
    {
        return $this->Adult;
    }
    /**
     * Set Adult value
     * @param \StructType\JPSOAP_Price $adult
     * @return \StructType\JPSOAP_RatePrice
     */
    public function setAdult(\StructType\JPSOAP_Price $adult = null)
    {
        $this->Adult = $adult;
        return $this;
    }
    /**
     * Get Room value
     * @return \StructType\JPSOAP_Price|null
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * Set Room value
     * @param \StructType\JPSOAP_Price $room
     * @return \StructType\JPSOAP_RatePrice
     */
    public function setRoom(\StructType\JPSOAP_Price $room = null)
    {
        $this->Room = $room;
        return $this;
    }
    /**
     * Get AdultAdditionals value
     * @return \ArrayType\ArrayOfJPSOAP_OrderedPrice|null
     */
    public function getAdultAdditionals()
    {
        return $this->AdultAdditionals;
    }
    /**
     * Set AdultAdditionals value
     * @param \ArrayType\ArrayOfJPSOAP_OrderedPrice $adultAdditionals
     * @return \StructType\JPSOAP_RatePrice
     */
    public function setAdultAdditionals(\ArrayType\ArrayOfJPSOAP_OrderedPrice $adultAdditionals = null)
    {
        $this->AdultAdditionals = $adultAdditionals;
        return $this;
    }
    /**
     * Get ChildrenA value
     * @return \ArrayType\ArrayOfJPSOAP_OrderedPrice1|null
     */
    public function getChildrenA()
    {
        return $this->ChildrenA;
    }
    /**
     * Set ChildrenA value
     * @param \ArrayType\ArrayOfJPSOAP_OrderedPrice1 $childrenA
     * @return \StructType\JPSOAP_RatePrice
     */
    public function setChildrenA(\ArrayType\ArrayOfJPSOAP_OrderedPrice1 $childrenA = null)
    {
        $this->ChildrenA = $childrenA;
        return $this;
    }
    /**
     * Get ChildrenB value
     * @return \ArrayType\ArrayOfJPSOAP_OrderedPrice2|null
     */
    public function getChildrenB()
    {
        return $this->ChildrenB;
    }
    /**
     * Set ChildrenB value
     * @param \ArrayType\ArrayOfJPSOAP_OrderedPrice2 $childrenB
     * @return \StructType\JPSOAP_RatePrice
     */
    public function setChildrenB(\ArrayType\ArrayOfJPSOAP_OrderedPrice2 $childrenB = null)
    {
        $this->ChildrenB = $childrenB;
        return $this;
    }
    /**
     * Get ChildrenC value
     * @return \ArrayType\ArrayOfJPSOAP_OrderedPrice3|null
     */
    public function getChildrenC()
    {
        return $this->ChildrenC;
    }
    /**
     * Set ChildrenC value
     * @param \ArrayType\ArrayOfJPSOAP_OrderedPrice3 $childrenC
     * @return \StructType\JPSOAP_RatePrice
     */
    public function setChildrenC(\ArrayType\ArrayOfJPSOAP_OrderedPrice3 $childrenC = null)
    {
        $this->ChildrenC = $childrenC;
        return $this;
    }
}
