<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Room ServiceType
 * @subpackage Services
 */
class Room extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RoomList
     * Meta information extracted from the WSDL
     * - documentation: List of rooms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RoomList $parameters
     * @return \StructType\RoomListResponse|bool
     */
    public function RoomList(\StructType\RoomList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RoomList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RoomListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
