<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString2 ArrayType
 * @subpackage Arrays
 */
class ArrayOfString2 extends AbstractStructArrayBase
{
    /**
     * The Synonym
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Synonym;
    /**
     * Constructor method for ArrayOfString2
     * @uses ArrayOfString2::setSynonym()
     * @param string[] $synonym
     */
    public function __construct(array $synonym = array())
    {
        $this
            ->setSynonym($synonym);
    }
    /**
     * Get Synonym value
     * @return string[]|null
     */
    public function getSynonym()
    {
        return $this->Synonym;
    }
    /**
     * This method is responsible for validating the values passed to the setSynonym method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSynonym method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSynonymForArrayConstraintsFromSetSynonym(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfString2SynonymItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfString2SynonymItem)) {
                $invalidValues[] = is_object($arrayOfString2SynonymItem) ? get_class($arrayOfString2SynonymItem) : sprintf('%s(%s)', gettype($arrayOfString2SynonymItem), var_export($arrayOfString2SynonymItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Synonym property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Synonym value
     * @throws \InvalidArgumentException
     * @param string[] $synonym
     * @return \ArrayType\ArrayOfString2
     */
    public function setSynonym(array $synonym = array())
    {
        // validation for constraint: array
        if ('' !== ($synonymArrayErrorMessage = self::validateSynonymForArrayConstraintsFromSetSynonym($synonym))) {
            throw new \InvalidArgumentException($synonymArrayErrorMessage, __LINE__);
        }
        $this->Synonym = $synonym;
        return $this;
    }
    /**
     * Add item to Synonym value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString2
     */
    public function addToSynonym($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Synonym property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Synonym[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Synonym
     */
    public function getAttributeName()
    {
        return 'Synonym';
    }
}
