<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_RequiredFieldValue ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_RequiredFieldValue extends AbstractStructArrayBase
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_RequiredFieldValue[]
     */
    public $Value;
    /**
     * Constructor method for ArrayOfJP_RequiredFieldValue
     * @uses ArrayOfJP_RequiredFieldValue::setValue()
     * @param \StructType\JP_RequiredFieldValue[] $value
     */
    public function __construct(array $value = array())
    {
        $this
            ->setValue($value);
    }
    /**
     * Get Value value
     * @return \StructType\JP_RequiredFieldValue[]|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * This method is responsible for validating the values passed to the setValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueForArrayConstraintsFromSetValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_RequiredFieldValueValueItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_RequiredFieldValueValueItem instanceof \StructType\JP_RequiredFieldValue) {
                $invalidValues[] = is_object($arrayOfJP_RequiredFieldValueValueItem) ? get_class($arrayOfJP_RequiredFieldValueValueItem) : sprintf('%s(%s)', gettype($arrayOfJP_RequiredFieldValueValueItem), var_export($arrayOfJP_RequiredFieldValueValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Value property can only contain items of type \StructType\JP_RequiredFieldValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Value value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RequiredFieldValue[] $value
     * @return \ArrayType\ArrayOfJP_RequiredFieldValue
     */
    public function setValue(array $value = array())
    {
        // validation for constraint: array
        if ('' !== ($valueArrayErrorMessage = self::validateValueForArrayConstraintsFromSetValue($value))) {
            throw new \InvalidArgumentException($valueArrayErrorMessage, __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Add item to Value value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RequiredFieldValue $item
     * @return \ArrayType\ArrayOfJP_RequiredFieldValue
     */
    public function addToValue(\StructType\JP_RequiredFieldValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_RequiredFieldValue) {
            throw new \InvalidArgumentException(sprintf('The Value property can only contain items of type \StructType\JP_RequiredFieldValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Value[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_RequiredFieldValue|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_RequiredFieldValue|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_RequiredFieldValue|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_RequiredFieldValue|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_RequiredFieldValue|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Value
     */
    public function getAttributeName()
    {
        return 'Value';
    }
}
