<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Promotion ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Promotion extends AbstractStructArrayBase
{
    /**
     * The Promotion
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Promotion[]
     */
    public $Promotion;
    /**
     * Constructor method for ArrayOfJP_Promotion
     * @uses ArrayOfJP_Promotion::setPromotion()
     * @param \StructType\JP_Promotion[] $promotion
     */
    public function __construct(array $promotion = array())
    {
        $this
            ->setPromotion($promotion);
    }
    /**
     * Get Promotion value
     * @return \StructType\JP_Promotion[]|null
     */
    public function getPromotion()
    {
        return $this->Promotion;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionForArrayConstraintsFromSetPromotion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_PromotionPromotionItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_PromotionPromotionItem instanceof \StructType\JP_Promotion) {
                $invalidValues[] = is_object($arrayOfJP_PromotionPromotionItem) ? get_class($arrayOfJP_PromotionPromotionItem) : sprintf('%s(%s)', gettype($arrayOfJP_PromotionPromotionItem), var_export($arrayOfJP_PromotionPromotionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Promotion property can only contain items of type \StructType\JP_Promotion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Promotion value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Promotion[] $promotion
     * @return \ArrayType\ArrayOfJP_Promotion
     */
    public function setPromotion(array $promotion = array())
    {
        // validation for constraint: array
        if ('' !== ($promotionArrayErrorMessage = self::validatePromotionForArrayConstraintsFromSetPromotion($promotion))) {
            throw new \InvalidArgumentException($promotionArrayErrorMessage, __LINE__);
        }
        $this->Promotion = $promotion;
        return $this;
    }
    /**
     * Add item to Promotion value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Promotion $item
     * @return \ArrayType\ArrayOfJP_Promotion
     */
    public function addToPromotion(\StructType\JP_Promotion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Promotion) {
            throw new \InvalidArgumentException(sprintf('The Promotion property can only contain items of type \StructType\JP_Promotion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Promotion[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Promotion|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Promotion|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Promotion|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Promotion|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Promotion|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Promotion
     */
    public function getAttributeName()
    {
        return 'Promotion';
    }
}
