<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Ship StructType
 * @subpackage Structs
 */
class JP_Ship extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Shipping
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Shipping
     */
    public $Shipping;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Description
     */
    public $Description;
    /**
     * The Images
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString1
     */
    public $Images;
    /**
     * The ImagesLong
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ImageLong
     */
    public $ImagesLong;
    /**
     * The Cruises
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_CruiseList[]
     */
    public $Cruises;
    /**
     * The Overview
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Overview[]
     */
    public $Overview;
    /**
     * The Tipstandards
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tipstandards;
    /**
     * The Serv
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruiseServices
     */
    public $Serv;
    /**
     * The Sport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruiseSportServices
     */
    public $Sport;
    /**
     * The Nin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruiseChildServices
     */
    public $Nin;
    /**
     * The Cabin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruiseCabinServices
     */
    public $Cabin;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for JP_Ship
     * @uses JP_Ship::setName()
     * @uses JP_Ship::setShipping()
     * @uses JP_Ship::setDescription()
     * @uses JP_Ship::setImages()
     * @uses JP_Ship::setImagesLong()
     * @uses JP_Ship::setCruises()
     * @uses JP_Ship::setOverview()
     * @uses JP_Ship::setTipstandards()
     * @uses JP_Ship::setServ()
     * @uses JP_Ship::setSport()
     * @uses JP_Ship::setNin()
     * @uses JP_Ship::setCabin()
     * @uses JP_Ship::setCode()
     * @param string $name
     * @param \StructType\JP_Shipping $shipping
     * @param \StructType\JP_Description $description
     * @param \ArrayType\ArrayOfString1 $images
     * @param \ArrayType\ArrayOfJP_ImageLong $imagesLong
     * @param \StructType\JP_CruiseList[] $cruises
     * @param \StructType\JP_Overview[] $overview
     * @param string $tipstandards
     * @param \StructType\JP_CruiseServices $serv
     * @param \StructType\JP_CruiseSportServices $sport
     * @param \StructType\JP_CruiseChildServices $nin
     * @param \StructType\JP_CruiseCabinServices $cabin
     * @param string $code
     */
    public function __construct($name = null, \StructType\JP_Shipping $shipping = null, \StructType\JP_Description $description = null, \ArrayType\ArrayOfString1 $images = null, \ArrayType\ArrayOfJP_ImageLong $imagesLong = null, array $cruises = array(), array $overview = array(), $tipstandards = null, \StructType\JP_CruiseServices $serv = null, \StructType\JP_CruiseSportServices $sport = null, \StructType\JP_CruiseChildServices $nin = null, \StructType\JP_CruiseCabinServices $cabin = null, $code = null)
    {
        $this
            ->setName($name)
            ->setShipping($shipping)
            ->setDescription($description)
            ->setImages($images)
            ->setImagesLong($imagesLong)
            ->setCruises($cruises)
            ->setOverview($overview)
            ->setTipstandards($tipstandards)
            ->setServ($serv)
            ->setSport($sport)
            ->setNin($nin)
            ->setCabin($cabin)
            ->setCode($code);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_Ship
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Shipping value
     * @return \StructType\JP_Shipping|null
     */
    public function getShipping()
    {
        return $this->Shipping;
    }
    /**
     * Set Shipping value
     * @param \StructType\JP_Shipping $shipping
     * @return \StructType\JP_Ship
     */
    public function setShipping(\StructType\JP_Shipping $shipping = null)
    {
        $this->Shipping = $shipping;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\JP_Description|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\JP_Description $description
     * @return \StructType\JP_Ship
     */
    public function setDescription(\StructType\JP_Description $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Images value
     * @return \ArrayType\ArrayOfString1|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \ArrayType\ArrayOfString1 $images
     * @return \StructType\JP_Ship
     */
    public function setImages(\ArrayType\ArrayOfString1 $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get ImagesLong value
     * @return \ArrayType\ArrayOfJP_ImageLong|null
     */
    public function getImagesLong()
    {
        return $this->ImagesLong;
    }
    /**
     * Set ImagesLong value
     * @param \ArrayType\ArrayOfJP_ImageLong $imagesLong
     * @return \StructType\JP_Ship
     */
    public function setImagesLong(\ArrayType\ArrayOfJP_ImageLong $imagesLong = null)
    {
        $this->ImagesLong = $imagesLong;
        return $this;
    }
    /**
     * Get Cruises value
     * @return \StructType\JP_CruiseList[]|null
     */
    public function getCruises()
    {
        return $this->Cruises;
    }
    /**
     * Set Cruises value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CruiseList[] $cruises
     * @return \StructType\JP_Ship
     */
    public function setCruises(array $cruises = array())
    {
        foreach ($cruises as $jP_ShipCruisesItem) {
            // validation for constraint: itemType
            if (!$jP_ShipCruisesItem instanceof \StructType\JP_CruiseList) {
                throw new \InvalidArgumentException(sprintf('The Cruises property can only contain items of \StructType\JP_CruiseList, "%s" given', is_object($jP_ShipCruisesItem) ? get_class($jP_ShipCruisesItem) : gettype($jP_ShipCruisesItem)), __LINE__);
            }
        }
        $this->Cruises = $cruises;
        return $this;
    }
    /**
     * Add item to Cruises value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CruiseList $item
     * @return \StructType\JP_Ship
     */
    public function addToCruises(\StructType\JP_CruiseList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_CruiseList) {
            throw new \InvalidArgumentException(sprintf('The Cruises property can only contain items of \StructType\JP_CruiseList, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Cruises[] = $item;
        return $this;
    }
    /**
     * Get Overview value
     * @return \StructType\JP_Overview[]|null
     */
    public function getOverview()
    {
        return $this->Overview;
    }
    /**
     * Set Overview value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Overview[] $overview
     * @return \StructType\JP_Ship
     */
    public function setOverview(array $overview = array())
    {
        foreach ($overview as $jP_ShipOverviewItem) {
            // validation for constraint: itemType
            if (!$jP_ShipOverviewItem instanceof \StructType\JP_Overview) {
                throw new \InvalidArgumentException(sprintf('The Overview property can only contain items of \StructType\JP_Overview, "%s" given', is_object($jP_ShipOverviewItem) ? get_class($jP_ShipOverviewItem) : gettype($jP_ShipOverviewItem)), __LINE__);
            }
        }
        $this->Overview = $overview;
        return $this;
    }
    /**
     * Add item to Overview value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Overview $item
     * @return \StructType\JP_Ship
     */
    public function addToOverview(\StructType\JP_Overview $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Overview) {
            throw new \InvalidArgumentException(sprintf('The Overview property can only contain items of \StructType\JP_Overview, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Overview[] = $item;
        return $this;
    }
    /**
     * Get Tipstandards value
     * @return string|null
     */
    public function getTipstandards()
    {
        return $this->Tipstandards;
    }
    /**
     * Set Tipstandards value
     * @param string $tipstandards
     * @return \StructType\JP_Ship
     */
    public function setTipstandards($tipstandards = null)
    {
        // validation for constraint: string
        if (!is_null($tipstandards) && !is_string($tipstandards)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipstandards)), __LINE__);
        }
        $this->Tipstandards = $tipstandards;
        return $this;
    }
    /**
     * Get Serv value
     * @return \StructType\JP_CruiseServices|null
     */
    public function getServ()
    {
        return $this->Serv;
    }
    /**
     * Set Serv value
     * @param \StructType\JP_CruiseServices $serv
     * @return \StructType\JP_Ship
     */
    public function setServ(\StructType\JP_CruiseServices $serv = null)
    {
        $this->Serv = $serv;
        return $this;
    }
    /**
     * Get Sport value
     * @return \StructType\JP_CruiseSportServices|null
     */
    public function getSport()
    {
        return $this->Sport;
    }
    /**
     * Set Sport value
     * @param \StructType\JP_CruiseSportServices $sport
     * @return \StructType\JP_Ship
     */
    public function setSport(\StructType\JP_CruiseSportServices $sport = null)
    {
        $this->Sport = $sport;
        return $this;
    }
    /**
     * Get Nin value
     * @return \StructType\JP_CruiseChildServices|null
     */
    public function getNin()
    {
        return $this->Nin;
    }
    /**
     * Set Nin value
     * @param \StructType\JP_CruiseChildServices $nin
     * @return \StructType\JP_Ship
     */
    public function setNin(\StructType\JP_CruiseChildServices $nin = null)
    {
        $this->Nin = $nin;
        return $this;
    }
    /**
     * Get Cabin value
     * @return \StructType\JP_CruiseCabinServices|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @param \StructType\JP_CruiseCabinServices $cabin
     * @return \StructType\JP_Ship
     */
    public function setCabin(\StructType\JP_CruiseCabinServices $cabin = null)
    {
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_Ship
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Ship
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
