<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Refund StructType
 * @subpackage Structs
 */
class JP_Refund extends AbstractStructBase
{
    /**
     * The OrderCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderCode;
    /**
     * The PaymentType
     * @var string
     */
    public $PaymentType;
    /**
     * Constructor method for JP_Refund
     * @uses JP_Refund::setOrderCode()
     * @uses JP_Refund::setPaymentType()
     * @param string $orderCode
     * @param string $paymentType
     */
    public function __construct($orderCode = null, $paymentType = null)
    {
        $this
            ->setOrderCode($orderCode)
            ->setPaymentType($paymentType);
    }
    /**
     * Get OrderCode value
     * @return string|null
     */
    public function getOrderCode()
    {
        return $this->OrderCode;
    }
    /**
     * Set OrderCode value
     * @param string $orderCode
     * @return \StructType\JP_Refund
     */
    public function setOrderCode($orderCode = null)
    {
        // validation for constraint: string
        if (!is_null($orderCode) && !is_string($orderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderCode)), __LINE__);
        }
        $this->OrderCode = $orderCode;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \StructType\JP_Refund
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Refund
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
