<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_FareGroupPrice StructType
 * @subpackage Structs
 */
class JP_FareGroupPrice extends AbstractStructBase
{
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Price
     */
    public $Price;
    /**
     * The FareGroupCode
     * @var string
     */
    public $FareGroupCode;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * Constructor method for JP_FareGroupPrice
     * @uses JP_FareGroupPrice::setPrice()
     * @uses JP_FareGroupPrice::setFareGroupCode()
     * @uses JP_FareGroupPrice::setRatePlanCode()
     * @param \StructType\JP_Price $price
     * @param string $fareGroupCode
     * @param string $ratePlanCode
     */
    public function __construct(\StructType\JP_Price $price = null, $fareGroupCode = null, $ratePlanCode = null)
    {
        $this
            ->setPrice($price)
            ->setFareGroupCode($fareGroupCode)
            ->setRatePlanCode($ratePlanCode);
    }
    /**
     * Get Price value
     * @return \StructType\JP_Price|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\JP_Price $price
     * @return \StructType\JP_FareGroupPrice
     */
    public function setPrice(\StructType\JP_Price $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get FareGroupCode value
     * @return string|null
     */
    public function getFareGroupCode()
    {
        return $this->FareGroupCode;
    }
    /**
     * Set FareGroupCode value
     * @param string $fareGroupCode
     * @return \StructType\JP_FareGroupPrice
     */
    public function setFareGroupCode($fareGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareGroupCode) && !is_string($fareGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareGroupCode)), __LINE__);
        }
        $this->FareGroupCode = $fareGroupCode;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_FareGroupPrice
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_FareGroupPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
