<?php

namespace EnumType;

/**
 * This class stands for JP_ContractType EnumType
 * @subpackage Enumerations
 */
class JP_ContractType
{
    /**
     * Constant for value 'Expedia'
     * @return string 'Expedia'
     */
    const VALUE_EXPEDIA = 'Expedia';
    /**
     * Constant for value 'FIT'
     * @return string 'FIT'
     */
    const VALUE_FIT = 'FIT';
    /**
     * Constant for value 'Guarantee'
     * @return string 'Guarantee'
     */
    const VALUE_GUARANTEE = 'Guarantee';
    /**
     * Constant for value 'Promo'
     * @return string 'Promo'
     */
    const VALUE_PROMO = 'Promo';
    /**
     * Constant for value 'Rack'
     * @return string 'Rack'
     */
    const VALUE_RACK = 'Rack';
    /**
     * Constant for value 'BAR'
     * @return string 'BAR'
     */
    const VALUE_BAR = 'BAR';
    /**
     * Constant for value 'Deposit'
     * @return string 'Deposit'
     */
    const VALUE_DEPOSIT = 'Deposit';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EXPEDIA
     * @uses self::VALUE_FIT
     * @uses self::VALUE_GUARANTEE
     * @uses self::VALUE_PROMO
     * @uses self::VALUE_RACK
     * @uses self::VALUE_BAR
     * @uses self::VALUE_DEPOSIT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EXPEDIA,
            self::VALUE_FIT,
            self::VALUE_GUARANTEE,
            self::VALUE_PROMO,
            self::VALUE_RACK,
            self::VALUE_BAR,
            self::VALUE_DEPOSIT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
