<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_ServiceContract ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_ServiceContract extends AbstractStructArrayBase
{
    /**
     * The Contract
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ServiceContract[]
     */
    public $Contract;
    /**
     * Constructor method for ArrayOfJP_ServiceContract
     * @uses ArrayOfJP_ServiceContract::setContract()
     * @param \StructType\JP_ServiceContract[] $contract
     */
    public function __construct(array $contract = array())
    {
        $this
            ->setContract($contract);
    }
    /**
     * Get Contract value
     * @return \StructType\JP_ServiceContract[]|null
     */
    public function getContract()
    {
        return $this->Contract;
    }
    /**
     * Set Contract value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceContract[] $contract
     * @return \ArrayType\ArrayOfJP_ServiceContract
     */
    public function setContract(array $contract = array())
    {
        foreach ($contract as $arrayOfJP_ServiceContractContractItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_ServiceContractContractItem instanceof \StructType\JP_ServiceContract) {
                throw new \InvalidArgumentException(sprintf('The Contract property can only contain items of \StructType\JP_ServiceContract, "%s" given', is_object($arrayOfJP_ServiceContractContractItem) ? get_class($arrayOfJP_ServiceContractContractItem) : gettype($arrayOfJP_ServiceContractContractItem)), __LINE__);
            }
        }
        $this->Contract = $contract;
        return $this;
    }
    /**
     * Add item to Contract value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceContract $item
     * @return \ArrayType\ArrayOfJP_ServiceContract
     */
    public function addToContract(\StructType\JP_ServiceContract $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ServiceContract) {
            throw new \InvalidArgumentException(sprintf('The Contract property can only contain items of \StructType\JP_ServiceContract, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Contract[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_ServiceContract|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_ServiceContract|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_ServiceContract|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_ServiceContract|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_ServiceContract|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Contract
     */
    public function getAttributeName()
    {
        return 'Contract';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_ServiceContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
