<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_HotelRoom ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_HotelRoom extends AbstractStructArrayBase
{
    /**
     * The HotelRoom
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_HotelRoom[]
     */
    public $HotelRoom;
    /**
     * Constructor method for ArrayOfJP_HotelRoom
     * @uses ArrayOfJP_HotelRoom::setHotelRoom()
     * @param \StructType\JP_HotelRoom[] $hotelRoom
     */
    public function __construct(array $hotelRoom = array())
    {
        $this
            ->setHotelRoom($hotelRoom);
    }
    /**
     * Get HotelRoom value
     * @return \StructType\JP_HotelRoom[]|null
     */
    public function getHotelRoom()
    {
        return $this->HotelRoom;
    }
    /**
     * Set HotelRoom value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelRoom[] $hotelRoom
     * @return \ArrayType\ArrayOfJP_HotelRoom
     */
    public function setHotelRoom(array $hotelRoom = array())
    {
        foreach ($hotelRoom as $arrayOfJP_HotelRoomHotelRoomItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_HotelRoomHotelRoomItem instanceof \StructType\JP_HotelRoom) {
                throw new \InvalidArgumentException(sprintf('The HotelRoom property can only contain items of \StructType\JP_HotelRoom, "%s" given', is_object($arrayOfJP_HotelRoomHotelRoomItem) ? get_class($arrayOfJP_HotelRoomHotelRoomItem) : gettype($arrayOfJP_HotelRoomHotelRoomItem)), __LINE__);
            }
        }
        $this->HotelRoom = $hotelRoom;
        return $this;
    }
    /**
     * Add item to HotelRoom value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelRoom $item
     * @return \ArrayType\ArrayOfJP_HotelRoom
     */
    public function addToHotelRoom(\StructType\JP_HotelRoom $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_HotelRoom) {
            throw new \InvalidArgumentException(sprintf('The HotelRoom property can only contain items of \StructType\JP_HotelRoom, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->HotelRoom[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_HotelRoom|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_HotelRoom|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_HotelRoom|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_HotelRoom|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_HotelRoom|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string HotelRoom
     */
    public function getAttributeName()
    {
        return 'HotelRoom';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_HotelRoom
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
