<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ZoneInfo StructType
 * @subpackage Structs
 */
class JP_ZoneInfo extends JP_Zone
{
    /**
     * The FullName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FullName;
    /**
     * The NameByLanguages
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ZoneNameByLanguage[]
     */
    public $NameByLanguages;
    /**
     * Constructor method for JP_ZoneInfo
     * @uses JP_ZoneInfo::setFullName()
     * @uses JP_ZoneInfo::setNameByLanguages()
     * @param string $fullName
     * @param \StructType\JP_ZoneNameByLanguage[] $nameByLanguages
     */
    public function __construct($fullName = null, array $nameByLanguages = array())
    {
        $this
            ->setFullName($fullName)
            ->setNameByLanguages($nameByLanguages);
    }
    /**
     * Get FullName value
     * @return string|null
     */
    public function getFullName()
    {
        return $this->FullName;
    }
    /**
     * Set FullName value
     * @param string $fullName
     * @return \StructType\JP_ZoneInfo
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fullName)), __LINE__);
        }
        $this->FullName = $fullName;
        return $this;
    }
    /**
     * Get NameByLanguages value
     * @return \StructType\JP_ZoneNameByLanguage[]|null
     */
    public function getNameByLanguages()
    {
        return $this->NameByLanguages;
    }
    /**
     * Set NameByLanguages value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ZoneNameByLanguage[] $nameByLanguages
     * @return \StructType\JP_ZoneInfo
     */
    public function setNameByLanguages(array $nameByLanguages = array())
    {
        foreach ($nameByLanguages as $jP_ZoneInfoNameByLanguagesItem) {
            // validation for constraint: itemType
            if (!$jP_ZoneInfoNameByLanguagesItem instanceof \StructType\JP_ZoneNameByLanguage) {
                throw new \InvalidArgumentException(sprintf('The NameByLanguages property can only contain items of \StructType\JP_ZoneNameByLanguage, "%s" given', is_object($jP_ZoneInfoNameByLanguagesItem) ? get_class($jP_ZoneInfoNameByLanguagesItem) : gettype($jP_ZoneInfoNameByLanguagesItem)), __LINE__);
            }
        }
        $this->NameByLanguages = $nameByLanguages;
        return $this;
    }
    /**
     * Add item to NameByLanguages value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ZoneNameByLanguage $item
     * @return \StructType\JP_ZoneInfo
     */
    public function addToNameByLanguages(\StructType\JP_ZoneNameByLanguage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ZoneNameByLanguage) {
            throw new \InvalidArgumentException(sprintf('The NameByLanguages property can only contain items of \StructType\JP_ZoneNameByLanguage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NameByLanguages[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ZoneInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
