<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_RentacarLocation StructType
 * @subpackage Structs
 */
class JP_RentacarLocation extends AbstractStructBase
{
    /**
     * The PickUpCode
     * @var string
     */
    public $PickUpCode;
    /**
     * The DropOffCode
     * @var string
     */
    public $DropOffCode;
    /**
     * Constructor method for JP_RentacarLocation
     * @uses JP_RentacarLocation::setPickUpCode()
     * @uses JP_RentacarLocation::setDropOffCode()
     * @param string $pickUpCode
     * @param string $dropOffCode
     */
    public function __construct($pickUpCode = null, $dropOffCode = null)
    {
        $this
            ->setPickUpCode($pickUpCode)
            ->setDropOffCode($dropOffCode);
    }
    /**
     * Get PickUpCode value
     * @return string|null
     */
    public function getPickUpCode()
    {
        return $this->PickUpCode;
    }
    /**
     * Set PickUpCode value
     * @param string $pickUpCode
     * @return \StructType\JP_RentacarLocation
     */
    public function setPickUpCode($pickUpCode = null)
    {
        // validation for constraint: string
        if (!is_null($pickUpCode) && !is_string($pickUpCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pickUpCode)), __LINE__);
        }
        $this->PickUpCode = $pickUpCode;
        return $this;
    }
    /**
     * Get DropOffCode value
     * @return string|null
     */
    public function getDropOffCode()
    {
        return $this->DropOffCode;
    }
    /**
     * Set DropOffCode value
     * @param string $dropOffCode
     * @return \StructType\JP_RentacarLocation
     */
    public function setDropOffCode($dropOffCode = null)
    {
        // validation for constraint: string
        if (!is_null($dropOffCode) && !is_string($dropOffCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dropOffCode)), __LINE__);
        }
        $this->DropOffCode = $dropOffCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_RentacarLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
