<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Contents StructType
 * @subpackage Structs
 */
class JP_Contents extends AbstractStructBase
{
    /**
     * The HotelContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_HotelContent[]
     */
    public $HotelContent;
    /**
     * The PackageContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_PackageContent[]
     */
    public $PackageContent;
    /**
     * The RentacarLocationContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_RentacarLocationDetail[]
     */
    public $RentacarLocationContent;
    /**
     * Constructor method for JP_Contents
     * @uses JP_Contents::setHotelContent()
     * @uses JP_Contents::setPackageContent()
     * @uses JP_Contents::setRentacarLocationContent()
     * @param \StructType\JP_HotelContent[] $hotelContent
     * @param \StructType\JP_PackageContent[] $packageContent
     * @param \StructType\JP_RentacarLocationDetail[] $rentacarLocationContent
     */
    public function __construct(array $hotelContent = array(), array $packageContent = array(), array $rentacarLocationContent = array())
    {
        $this
            ->setHotelContent($hotelContent)
            ->setPackageContent($packageContent)
            ->setRentacarLocationContent($rentacarLocationContent);
    }
    /**
     * Get HotelContent value
     * @return \StructType\JP_HotelContent[]|null
     */
    public function getHotelContent()
    {
        return $this->HotelContent;
    }
    /**
     * Set HotelContent value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelContent[] $hotelContent
     * @return \StructType\JP_Contents
     */
    public function setHotelContent(array $hotelContent = array())
    {
        foreach ($hotelContent as $jP_ContentsHotelContentItem) {
            // validation for constraint: itemType
            if (!$jP_ContentsHotelContentItem instanceof \StructType\JP_HotelContent) {
                throw new \InvalidArgumentException(sprintf('The HotelContent property can only contain items of \StructType\JP_HotelContent, "%s" given', is_object($jP_ContentsHotelContentItem) ? get_class($jP_ContentsHotelContentItem) : gettype($jP_ContentsHotelContentItem)), __LINE__);
            }
        }
        $this->HotelContent = $hotelContent;
        return $this;
    }
    /**
     * Add item to HotelContent value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelContent $item
     * @return \StructType\JP_Contents
     */
    public function addToHotelContent(\StructType\JP_HotelContent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_HotelContent) {
            throw new \InvalidArgumentException(sprintf('The HotelContent property can only contain items of \StructType\JP_HotelContent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->HotelContent[] = $item;
        return $this;
    }
    /**
     * Get PackageContent value
     * @return \StructType\JP_PackageContent[]|null
     */
    public function getPackageContent()
    {
        return $this->PackageContent;
    }
    /**
     * Set PackageContent value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageContent[] $packageContent
     * @return \StructType\JP_Contents
     */
    public function setPackageContent(array $packageContent = array())
    {
        foreach ($packageContent as $jP_ContentsPackageContentItem) {
            // validation for constraint: itemType
            if (!$jP_ContentsPackageContentItem instanceof \StructType\JP_PackageContent) {
                throw new \InvalidArgumentException(sprintf('The PackageContent property can only contain items of \StructType\JP_PackageContent, "%s" given', is_object($jP_ContentsPackageContentItem) ? get_class($jP_ContentsPackageContentItem) : gettype($jP_ContentsPackageContentItem)), __LINE__);
            }
        }
        $this->PackageContent = $packageContent;
        return $this;
    }
    /**
     * Add item to PackageContent value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageContent $item
     * @return \StructType\JP_Contents
     */
    public function addToPackageContent(\StructType\JP_PackageContent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_PackageContent) {
            throw new \InvalidArgumentException(sprintf('The PackageContent property can only contain items of \StructType\JP_PackageContent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PackageContent[] = $item;
        return $this;
    }
    /**
     * Get RentacarLocationContent value
     * @return \StructType\JP_RentacarLocationDetail[]|null
     */
    public function getRentacarLocationContent()
    {
        return $this->RentacarLocationContent;
    }
    /**
     * Set RentacarLocationContent value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RentacarLocationDetail[] $rentacarLocationContent
     * @return \StructType\JP_Contents
     */
    public function setRentacarLocationContent(array $rentacarLocationContent = array())
    {
        foreach ($rentacarLocationContent as $jP_ContentsRentacarLocationContentItem) {
            // validation for constraint: itemType
            if (!$jP_ContentsRentacarLocationContentItem instanceof \StructType\JP_RentacarLocationDetail) {
                throw new \InvalidArgumentException(sprintf('The RentacarLocationContent property can only contain items of \StructType\JP_RentacarLocationDetail, "%s" given', is_object($jP_ContentsRentacarLocationContentItem) ? get_class($jP_ContentsRentacarLocationContentItem) : gettype($jP_ContentsRentacarLocationContentItem)), __LINE__);
            }
        }
        $this->RentacarLocationContent = $rentacarLocationContent;
        return $this;
    }
    /**
     * Add item to RentacarLocationContent value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RentacarLocationDetail $item
     * @return \StructType\JP_Contents
     */
    public function addToRentacarLocationContent(\StructType\JP_RentacarLocationDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_RentacarLocationDetail) {
            throw new \InvalidArgumentException(sprintf('The RentacarLocationContent property can only contain items of \StructType\JP_RentacarLocationDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RentacarLocationContent[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Contents
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
