<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Routes StructType
 * @subpackage Structs
 */
class JP_Routes extends AbstractStructBase
{
    /**
     * The Route
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Route[]
     */
    public $Route;
    /**
     * The ValidatingCarrier
     * @var string
     */
    public $ValidatingCarrier;
    /**
     * Constructor method for JP_Routes
     * @uses JP_Routes::setRoute()
     * @uses JP_Routes::setValidatingCarrier()
     * @param \StructType\JP_Route[] $route
     * @param string $validatingCarrier
     */
    public function __construct(array $route = array(), $validatingCarrier = null)
    {
        $this
            ->setRoute($route)
            ->setValidatingCarrier($validatingCarrier);
    }
    /**
     * Get Route value
     * @return \StructType\JP_Route[]|null
     */
    public function getRoute()
    {
        return $this->Route;
    }
    /**
     * Set Route value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Route[] $route
     * @return \StructType\JP_Routes
     */
    public function setRoute(array $route = array())
    {
        foreach ($route as $jP_RoutesRouteItem) {
            // validation for constraint: itemType
            if (!$jP_RoutesRouteItem instanceof \StructType\JP_Route) {
                throw new \InvalidArgumentException(sprintf('The Route property can only contain items of \StructType\JP_Route, "%s" given', is_object($jP_RoutesRouteItem) ? get_class($jP_RoutesRouteItem) : gettype($jP_RoutesRouteItem)), __LINE__);
            }
        }
        $this->Route = $route;
        return $this;
    }
    /**
     * Add item to Route value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Route $item
     * @return \StructType\JP_Routes
     */
    public function addToRoute(\StructType\JP_Route $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Route) {
            throw new \InvalidArgumentException(sprintf('The Route property can only contain items of \StructType\JP_Route, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Route[] = $item;
        return $this;
    }
    /**
     * Get ValidatingCarrier value
     * @return string|null
     */
    public function getValidatingCarrier()
    {
        return $this->ValidatingCarrier;
    }
    /**
     * Set ValidatingCarrier value
     * @param string $validatingCarrier
     * @return \StructType\JP_Routes
     */
    public function setValidatingCarrier($validatingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($validatingCarrier) && !is_string($validatingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validatingCarrier)), __LINE__);
        }
        $this->ValidatingCarrier = $validatingCarrier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Routes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
