<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PaymentRequest StructType
 * @subpackage Structs
 */
class JP_PaymentRequest extends AbstractStructBase
{
    /**
     * The CheckPaymentToken
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckPaymentToken;
    /**
     * The Payment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Payment
     */
    public $Payment;
    /**
     * The Refund
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Refund
     */
    public $Refund;
    /**
     * The ReservationLocator
     * @var string
     */
    public $ReservationLocator;
    /**
     * Constructor method for JP_PaymentRequest
     * @uses JP_PaymentRequest::setCheckPaymentToken()
     * @uses JP_PaymentRequest::setPayment()
     * @uses JP_PaymentRequest::setRefund()
     * @uses JP_PaymentRequest::setReservationLocator()
     * @param string $checkPaymentToken
     * @param \StructType\JP_Payment $payment
     * @param \StructType\JP_Refund $refund
     * @param string $reservationLocator
     */
    public function __construct($checkPaymentToken = null, \StructType\JP_Payment $payment = null, \StructType\JP_Refund $refund = null, $reservationLocator = null)
    {
        $this
            ->setCheckPaymentToken($checkPaymentToken)
            ->setPayment($payment)
            ->setRefund($refund)
            ->setReservationLocator($reservationLocator);
    }
    /**
     * Get CheckPaymentToken value
     * @return string|null
     */
    public function getCheckPaymentToken()
    {
        return $this->CheckPaymentToken;
    }
    /**
     * Set CheckPaymentToken value
     * @param string $checkPaymentToken
     * @return \StructType\JP_PaymentRequest
     */
    public function setCheckPaymentToken($checkPaymentToken = null)
    {
        // validation for constraint: string
        if (!is_null($checkPaymentToken) && !is_string($checkPaymentToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkPaymentToken)), __LINE__);
        }
        $this->CheckPaymentToken = $checkPaymentToken;
        return $this;
    }
    /**
     * Get Payment value
     * @return \StructType\JP_Payment|null
     */
    public function getPayment()
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @param \StructType\JP_Payment $payment
     * @return \StructType\JP_PaymentRequest
     */
    public function setPayment(\StructType\JP_Payment $payment = null)
    {
        $this->Payment = $payment;
        return $this;
    }
    /**
     * Get Refund value
     * @return \StructType\JP_Refund|null
     */
    public function getRefund()
    {
        return $this->Refund;
    }
    /**
     * Set Refund value
     * @param \StructType\JP_Refund $refund
     * @return \StructType\JP_PaymentRequest
     */
    public function setRefund(\StructType\JP_Refund $refund = null)
    {
        $this->Refund = $refund;
        return $this;
    }
    /**
     * Get ReservationLocator value
     * @return string|null
     */
    public function getReservationLocator()
    {
        return $this->ReservationLocator;
    }
    /**
     * Set ReservationLocator value
     * @param string $reservationLocator
     * @return \StructType\JP_PaymentRequest
     */
    public function setReservationLocator($reservationLocator = null)
    {
        // validation for constraint: string
        if (!is_null($reservationLocator) && !is_string($reservationLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationLocator)), __LINE__);
        }
        $this->ReservationLocator = $reservationLocator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_PaymentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
