<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Paxes StructType
 * @subpackage Structs
 */
class JP_Paxes extends AbstractStructBase
{
    /**
     * The Pax
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Pax[]
     */
    public $Pax;
    /**
     * The AdultsFree
     * @var int
     */
    public $AdultsFree;
    /**
     * The ChildrenFree
     * @var int
     */
    public $ChildrenFree;
    /**
     * Constructor method for JP_Paxes
     * @uses JP_Paxes::setPax()
     * @uses JP_Paxes::setAdultsFree()
     * @uses JP_Paxes::setChildrenFree()
     * @param \StructType\JP_Pax[] $pax
     * @param int $adultsFree
     * @param int $childrenFree
     */
    public function __construct(array $pax = array(), $adultsFree = null, $childrenFree = null)
    {
        $this
            ->setPax($pax)
            ->setAdultsFree($adultsFree)
            ->setChildrenFree($childrenFree);
    }
    /**
     * Get Pax value
     * @return \StructType\JP_Pax[]|null
     */
    public function getPax()
    {
        return $this->Pax;
    }
    /**
     * Set Pax value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Pax[] $pax
     * @return \StructType\JP_Paxes
     */
    public function setPax(array $pax = array())
    {
        foreach ($pax as $jP_PaxesPaxItem) {
            // validation for constraint: itemType
            if (!$jP_PaxesPaxItem instanceof \StructType\JP_Pax) {
                throw new \InvalidArgumentException(sprintf('The Pax property can only contain items of \StructType\JP_Pax, "%s" given', is_object($jP_PaxesPaxItem) ? get_class($jP_PaxesPaxItem) : gettype($jP_PaxesPaxItem)), __LINE__);
            }
        }
        $this->Pax = $pax;
        return $this;
    }
    /**
     * Add item to Pax value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Pax $item
     * @return \StructType\JP_Paxes
     */
    public function addToPax(\StructType\JP_Pax $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Pax) {
            throw new \InvalidArgumentException(sprintf('The Pax property can only contain items of \StructType\JP_Pax, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Pax[] = $item;
        return $this;
    }
    /**
     * Get AdultsFree value
     * @return int|null
     */
    public function getAdultsFree()
    {
        return $this->AdultsFree;
    }
    /**
     * Set AdultsFree value
     * @param int $adultsFree
     * @return \StructType\JP_Paxes
     */
    public function setAdultsFree($adultsFree = null)
    {
        // validation for constraint: int
        if (!is_null($adultsFree) && !is_numeric($adultsFree)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($adultsFree)), __LINE__);
        }
        $this->AdultsFree = $adultsFree;
        return $this;
    }
    /**
     * Get ChildrenFree value
     * @return int|null
     */
    public function getChildrenFree()
    {
        return $this->ChildrenFree;
    }
    /**
     * Set ChildrenFree value
     * @param int $childrenFree
     * @return \StructType\JP_Paxes
     */
    public function setChildrenFree($childrenFree = null)
    {
        // validation for constraint: int
        if (!is_null($childrenFree) && !is_numeric($childrenFree)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($childrenFree)), __LINE__);
        }
        $this->ChildrenFree = $childrenFree;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Paxes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
