<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_AgencyList StructType
 * @subpackage Structs
 */
class JP_AgencyList extends AbstractStructBase
{
    /**
     * The AgencyData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_AgencyStaticData[]
     */
    public $AgencyData;
    /**
     * The Url
     * @var string
     */
    public $Url;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The IntCode
     * @var string
     */
    public $IntCode;
    /**
     * Constructor method for JP_AgencyList
     * @uses JP_AgencyList::setAgencyData()
     * @uses JP_AgencyList::setUrl()
     * @uses JP_AgencyList::setTimeStamp()
     * @uses JP_AgencyList::setIntCode()
     * @param \StructType\JP_AgencyStaticData[] $agencyData
     * @param string $url
     * @param string $timeStamp
     * @param string $intCode
     */
    public function __construct(array $agencyData = array(), $url = null, $timeStamp = null, $intCode = null)
    {
        $this
            ->setAgencyData($agencyData)
            ->setUrl($url)
            ->setTimeStamp($timeStamp)
            ->setIntCode($intCode);
    }
    /**
     * Get AgencyData value
     * @return \StructType\JP_AgencyStaticData[]|null
     */
    public function getAgencyData()
    {
        return $this->AgencyData;
    }
    /**
     * Set AgencyData value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_AgencyStaticData[] $agencyData
     * @return \StructType\JP_AgencyList
     */
    public function setAgencyData(array $agencyData = array())
    {
        foreach ($agencyData as $jP_AgencyListAgencyDataItem) {
            // validation for constraint: itemType
            if (!$jP_AgencyListAgencyDataItem instanceof \StructType\JP_AgencyStaticData) {
                throw new \InvalidArgumentException(sprintf('The AgencyData property can only contain items of \StructType\JP_AgencyStaticData, "%s" given', is_object($jP_AgencyListAgencyDataItem) ? get_class($jP_AgencyListAgencyDataItem) : gettype($jP_AgencyListAgencyDataItem)), __LINE__);
            }
        }
        $this->AgencyData = $agencyData;
        return $this;
    }
    /**
     * Add item to AgencyData value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_AgencyStaticData $item
     * @return \StructType\JP_AgencyList
     */
    public function addToAgencyData(\StructType\JP_AgencyStaticData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_AgencyStaticData) {
            throw new \InvalidArgumentException(sprintf('The AgencyData property can only contain items of \StructType\JP_AgencyStaticData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AgencyData[] = $item;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \StructType\JP_AgencyList
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\JP_AgencyList
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get IntCode value
     * @return string|null
     */
    public function getIntCode()
    {
        return $this->IntCode;
    }
    /**
     * Set IntCode value
     * @param string $intCode
     * @return \StructType\JP_AgencyList
     */
    public function setIntCode($intCode = null)
    {
        // validation for constraint: string
        if (!is_null($intCode) && !is_string($intCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($intCode)), __LINE__);
        }
        $this->IntCode = $intCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_AgencyList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
