<?php

namespace EnumType;

/**
 * This class stands for Action EnumType
 * @subpackage Enumerations
 */
class Action
{
    /**
     * Constant for value 'PAY'
     * @return string 'PAY'
     */
    const VALUE_PAY = 'PAY';
    /**
     * Constant for value 'RFD'
     * @return string 'RFD'
     */
    const VALUE_RFD = 'RFD';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PAY
     * @uses self::VALUE_RFD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PAY,
            self::VALUE_RFD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
