<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Ship ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Ship extends AbstractStructArrayBase
{
    /**
     * The Ship
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Ship[]
     */
    public $Ship;
    /**
     * Constructor method for ArrayOfJP_Ship
     * @uses ArrayOfJP_Ship::setShip()
     * @param \StructType\JP_Ship[] $ship
     */
    public function __construct(array $ship = array())
    {
        $this
            ->setShip($ship);
    }
    /**
     * Get Ship value
     * @return \StructType\JP_Ship[]|null
     */
    public function getShip()
    {
        return $this->Ship;
    }
    /**
     * Set Ship value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Ship[] $ship
     * @return \ArrayType\ArrayOfJP_Ship
     */
    public function setShip(array $ship = array())
    {
        foreach ($ship as $arrayOfJP_ShipShipItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_ShipShipItem instanceof \StructType\JP_Ship) {
                throw new \InvalidArgumentException(sprintf('The Ship property can only contain items of \StructType\JP_Ship, "%s" given', is_object($arrayOfJP_ShipShipItem) ? get_class($arrayOfJP_ShipShipItem) : gettype($arrayOfJP_ShipShipItem)), __LINE__);
            }
        }
        $this->Ship = $ship;
        return $this;
    }
    /**
     * Add item to Ship value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Ship $item
     * @return \ArrayType\ArrayOfJP_Ship
     */
    public function addToShip(\StructType\JP_Ship $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Ship) {
            throw new \InvalidArgumentException(sprintf('The Ship property can only contain items of \StructType\JP_Ship, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Ship[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Ship|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Ship|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Ship|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Ship|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Ship|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Ship
     */
    public function getAttributeName()
    {
        return 'Ship';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_Ship
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
