<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_HotelOption ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_HotelOption extends AbstractStructArrayBase
{
    /**
     * The HotelOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_HotelOption[]
     */
    public $HotelOption;
    /**
     * Constructor method for ArrayOfJP_HotelOption
     * @uses ArrayOfJP_HotelOption::setHotelOption()
     * @param \StructType\JP_HotelOption[] $hotelOption
     */
    public function __construct(array $hotelOption = array())
    {
        $this
            ->setHotelOption($hotelOption);
    }
    /**
     * Get HotelOption value
     * @return \StructType\JP_HotelOption[]|null
     */
    public function getHotelOption()
    {
        return $this->HotelOption;
    }
    /**
     * Set HotelOption value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelOption[] $hotelOption
     * @return \ArrayType\ArrayOfJP_HotelOption
     */
    public function setHotelOption(array $hotelOption = array())
    {
        foreach ($hotelOption as $arrayOfJP_HotelOptionHotelOptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_HotelOptionHotelOptionItem instanceof \StructType\JP_HotelOption) {
                throw new \InvalidArgumentException(sprintf('The HotelOption property can only contain items of \StructType\JP_HotelOption, "%s" given', is_object($arrayOfJP_HotelOptionHotelOptionItem) ? get_class($arrayOfJP_HotelOptionHotelOptionItem) : gettype($arrayOfJP_HotelOptionHotelOptionItem)), __LINE__);
            }
        }
        $this->HotelOption = $hotelOption;
        return $this;
    }
    /**
     * Add item to HotelOption value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelOption $item
     * @return \ArrayType\ArrayOfJP_HotelOption
     */
    public function addToHotelOption(\StructType\JP_HotelOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_HotelOption) {
            throw new \InvalidArgumentException(sprintf('The HotelOption property can only contain items of \StructType\JP_HotelOption, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->HotelOption[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_HotelOption|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_HotelOption|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_HotelOption|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_HotelOption|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_HotelOption|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string HotelOption
     */
    public function getAttributeName()
    {
        return 'HotelOption';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_HotelOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
