<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_FinalCustomerStaticData ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_FinalCustomerStaticData extends AbstractStructArrayBase
{
    /**
     * The FinalCustomer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_FinalCustomerStaticData[]
     */
    public $FinalCustomer;
    /**
     * Constructor method for ArrayOfJP_FinalCustomerStaticData
     * @uses ArrayOfJP_FinalCustomerStaticData::setFinalCustomer()
     * @param \StructType\JP_FinalCustomerStaticData[] $finalCustomer
     */
    public function __construct(array $finalCustomer = array())
    {
        $this
            ->setFinalCustomer($finalCustomer);
    }
    /**
     * Get FinalCustomer value
     * @return \StructType\JP_FinalCustomerStaticData[]|null
     */
    public function getFinalCustomer()
    {
        return $this->FinalCustomer;
    }
    /**
     * Set FinalCustomer value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_FinalCustomerStaticData[] $finalCustomer
     * @return \ArrayType\ArrayOfJP_FinalCustomerStaticData
     */
    public function setFinalCustomer(array $finalCustomer = array())
    {
        foreach ($finalCustomer as $arrayOfJP_FinalCustomerStaticDataFinalCustomerItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_FinalCustomerStaticDataFinalCustomerItem instanceof \StructType\JP_FinalCustomerStaticData) {
                throw new \InvalidArgumentException(sprintf('The FinalCustomer property can only contain items of \StructType\JP_FinalCustomerStaticData, "%s" given', is_object($arrayOfJP_FinalCustomerStaticDataFinalCustomerItem) ? get_class($arrayOfJP_FinalCustomerStaticDataFinalCustomerItem) : gettype($arrayOfJP_FinalCustomerStaticDataFinalCustomerItem)), __LINE__);
            }
        }
        $this->FinalCustomer = $finalCustomer;
        return $this;
    }
    /**
     * Add item to FinalCustomer value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_FinalCustomerStaticData $item
     * @return \ArrayType\ArrayOfJP_FinalCustomerStaticData
     */
    public function addToFinalCustomer(\StructType\JP_FinalCustomerStaticData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_FinalCustomerStaticData) {
            throw new \InvalidArgumentException(sprintf('The FinalCustomer property can only contain items of \StructType\JP_FinalCustomerStaticData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FinalCustomer[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_FinalCustomerStaticData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_FinalCustomerStaticData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_FinalCustomerStaticData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_FinalCustomerStaticData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_FinalCustomerStaticData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FinalCustomer
     */
    public function getAttributeName()
    {
        return 'FinalCustomer';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_FinalCustomerStaticData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
