<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Bag ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Bag extends AbstractStructArrayBase
{
    /**
     * The Bag
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Bag[]
     */
    public $Bag;
    /**
     * Constructor method for ArrayOfJP_Bag
     * @uses ArrayOfJP_Bag::setBag()
     * @param \StructType\JP_Bag[] $bag
     */
    public function __construct(array $bag = array())
    {
        $this
            ->setBag($bag);
    }
    /**
     * Get Bag value
     * @return \StructType\JP_Bag[]|null
     */
    public function getBag()
    {
        return $this->Bag;
    }
    /**
     * Set Bag value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Bag[] $bag
     * @return \ArrayType\ArrayOfJP_Bag
     */
    public function setBag(array $bag = array())
    {
        foreach ($bag as $arrayOfJP_BagBagItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_BagBagItem instanceof \StructType\JP_Bag) {
                throw new \InvalidArgumentException(sprintf('The Bag property can only contain items of \StructType\JP_Bag, "%s" given', is_object($arrayOfJP_BagBagItem) ? get_class($arrayOfJP_BagBagItem) : gettype($arrayOfJP_BagBagItem)), __LINE__);
            }
        }
        $this->Bag = $bag;
        return $this;
    }
    /**
     * Add item to Bag value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Bag $item
     * @return \ArrayType\ArrayOfJP_Bag
     */
    public function addToBag(\StructType\JP_Bag $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Bag) {
            throw new \InvalidArgumentException(sprintf('The Bag property can only contain items of \StructType\JP_Bag, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Bag[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Bag|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Bag|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Bag|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Bag|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Bag|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Bag
     */
    public function getAttributeName()
    {
        return 'Bag';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_Bag
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
