<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJPSOAP_IdTypeIntName ArrayType
 * @subpackage Arrays
 */
class ArrayOfJPSOAP_IdTypeIntName extends AbstractStructArrayBase
{
    /**
     * The Board
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JPSOAP_IdTypeIntName[]
     */
    public $Board;
    /**
     * Constructor method for ArrayOfJPSOAP_IdTypeIntName
     * @uses ArrayOfJPSOAP_IdTypeIntName::setBoard()
     * @param \StructType\JPSOAP_IdTypeIntName[] $board
     */
    public function __construct(array $board = array())
    {
        $this
            ->setBoard($board);
    }
    /**
     * Get Board value
     * @return \StructType\JPSOAP_IdTypeIntName[]|null
     */
    public function getBoard()
    {
        return $this->Board;
    }
    /**
     * Set Board value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_IdTypeIntName[] $board
     * @return \ArrayType\ArrayOfJPSOAP_IdTypeIntName
     */
    public function setBoard(array $board = array())
    {
        foreach ($board as $arrayOfJPSOAP_IdTypeIntNameBoardItem) {
            // validation for constraint: itemType
            if (!$arrayOfJPSOAP_IdTypeIntNameBoardItem instanceof \StructType\JPSOAP_IdTypeIntName) {
                throw new \InvalidArgumentException(sprintf('The Board property can only contain items of \StructType\JPSOAP_IdTypeIntName, "%s" given', is_object($arrayOfJPSOAP_IdTypeIntNameBoardItem) ? get_class($arrayOfJPSOAP_IdTypeIntNameBoardItem) : gettype($arrayOfJPSOAP_IdTypeIntNameBoardItem)), __LINE__);
            }
        }
        $this->Board = $board;
        return $this;
    }
    /**
     * Add item to Board value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_IdTypeIntName $item
     * @return \ArrayType\ArrayOfJPSOAP_IdTypeIntName
     */
    public function addToBoard(\StructType\JPSOAP_IdTypeIntName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JPSOAP_IdTypeIntName) {
            throw new \InvalidArgumentException(sprintf('The Board property can only contain items of \StructType\JPSOAP_IdTypeIntName, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Board[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JPSOAP_IdTypeIntName|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JPSOAP_IdTypeIntName|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JPSOAP_IdTypeIntName|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JPSOAP_IdTypeIntName|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JPSOAP_IdTypeIntName|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Board
     */
    public function getAttributeName()
    {
        return 'Board';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJPSOAP_IdTypeIntName
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
