<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PriceInformationTransfer StructType
 * @subpackage Structs
 */
class JP_PriceInformationTransfer extends AbstractStructBase
{
    /**
     * The TransferInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransferInfo
     */
    public $TransferInfo;
    /**
     * The TransferOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_TransferOption
     */
    public $TransferOptions;
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The Origins
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Origin
     */
    public $Origins;
    /**
     * The Destinations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Destination
     */
    public $Destinations;
    /**
     * The BillingOrganization
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BillingOrganization
     */
    public $BillingOrganization;
    /**
     * Constructor method for JP_PriceInformationTransfer
     * @uses JP_PriceInformationTransfer::setTransferInfo()
     * @uses JP_PriceInformationTransfer::setTransferOptions()
     * @uses JP_PriceInformationTransfer::setPrices()
     * @uses JP_PriceInformationTransfer::setOrigins()
     * @uses JP_PriceInformationTransfer::setDestinations()
     * @uses JP_PriceInformationTransfer::setBillingOrganization()
     * @param \StructType\JP_TransferInfo $transferInfo
     * @param \ArrayType\ArrayOfJP_TransferOption $transferOptions
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param \ArrayType\ArrayOfJP_Origin $origins
     * @param \ArrayType\ArrayOfJP_Destination $destinations
     * @param \StructType\JP_BillingOrganization $billingOrganization
     */
    public function __construct(\StructType\JP_TransferInfo $transferInfo = null, \ArrayType\ArrayOfJP_TransferOption $transferOptions = null, \ArrayType\ArrayOfJP_Price $prices = null, \ArrayType\ArrayOfJP_Origin $origins = null, \ArrayType\ArrayOfJP_Destination $destinations = null, \StructType\JP_BillingOrganization $billingOrganization = null)
    {
        $this
            ->setTransferInfo($transferInfo)
            ->setTransferOptions($transferOptions)
            ->setPrices($prices)
            ->setOrigins($origins)
            ->setDestinations($destinations)
            ->setBillingOrganization($billingOrganization);
    }
    /**
     * Get TransferInfo value
     * @return \StructType\JP_TransferInfo|null
     */
    public function getTransferInfo()
    {
        return $this->TransferInfo;
    }
    /**
     * Set TransferInfo value
     * @param \StructType\JP_TransferInfo $transferInfo
     * @return \StructType\JP_PriceInformationTransfer
     */
    public function setTransferInfo(\StructType\JP_TransferInfo $transferInfo = null)
    {
        $this->TransferInfo = $transferInfo;
        return $this;
    }
    /**
     * Get TransferOptions value
     * @return \ArrayType\ArrayOfJP_TransferOption|null
     */
    public function getTransferOptions()
    {
        return $this->TransferOptions;
    }
    /**
     * Set TransferOptions value
     * @param \ArrayType\ArrayOfJP_TransferOption $transferOptions
     * @return \StructType\JP_PriceInformationTransfer
     */
    public function setTransferOptions(\ArrayType\ArrayOfJP_TransferOption $transferOptions = null)
    {
        $this->TransferOptions = $transferOptions;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_PriceInformationTransfer
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get Origins value
     * @return \ArrayType\ArrayOfJP_Origin|null
     */
    public function getOrigins()
    {
        return $this->Origins;
    }
    /**
     * Set Origins value
     * @param \ArrayType\ArrayOfJP_Origin $origins
     * @return \StructType\JP_PriceInformationTransfer
     */
    public function setOrigins(\ArrayType\ArrayOfJP_Origin $origins = null)
    {
        $this->Origins = $origins;
        return $this;
    }
    /**
     * Get Destinations value
     * @return \ArrayType\ArrayOfJP_Destination|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @param \ArrayType\ArrayOfJP_Destination $destinations
     * @return \StructType\JP_PriceInformationTransfer
     */
    public function setDestinations(\ArrayType\ArrayOfJP_Destination $destinations = null)
    {
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Get BillingOrganization value
     * @return \StructType\JP_BillingOrganization|null
     */
    public function getBillingOrganization()
    {
        return $this->BillingOrganization;
    }
    /**
     * Set BillingOrganization value
     * @param \StructType\JP_BillingOrganization $billingOrganization
     * @return \StructType\JP_PriceInformationTransfer
     */
    public function setBillingOrganization(\StructType\JP_BillingOrganization $billingOrganization = null)
    {
        $this->BillingOrganization = $billingOrganization;
        return $this;
    }
}
