<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Items StructType
 * @subpackage Structs
 */
class JP_Items extends AbstractStructBase
{
    /**
     * The FlightItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_FlightItem[]
     */
    public $FlightItem;
    /**
     * The HotelItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_HotelItem[]
     */
    public $HotelItem;
    /**
     * The PackageItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_PackageItem[]
     */
    public $PackageItem;
    /**
     * The CarItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_RentacarItem[]
     */
    public $CarItem;
    /**
     * The InsuranceItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_InsuranceItem[]
     */
    public $InsuranceItem;
    /**
     * The CruiseItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_CruiseItem[]
     */
    public $CruiseItem;
    /**
     * The ServiceItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ServiceItem[]
     */
    public $ServiceItem;
    /**
     * The TransferItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_TransferItem[]
     */
    public $TransferItem;
    /**
     * The VisaItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_VisaItem[]
     */
    public $VisaItem;
    /**
     * The AdjustmentItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_AdjustmentItem[]
     */
    public $AdjustmentItem;
    /**
     * Constructor method for JP_Items
     * @uses JP_Items::setFlightItem()
     * @uses JP_Items::setHotelItem()
     * @uses JP_Items::setPackageItem()
     * @uses JP_Items::setCarItem()
     * @uses JP_Items::setInsuranceItem()
     * @uses JP_Items::setCruiseItem()
     * @uses JP_Items::setServiceItem()
     * @uses JP_Items::setTransferItem()
     * @uses JP_Items::setVisaItem()
     * @uses JP_Items::setAdjustmentItem()
     * @param \StructType\JP_FlightItem[] $flightItem
     * @param \StructType\JP_HotelItem[] $hotelItem
     * @param \StructType\JP_PackageItem[] $packageItem
     * @param \StructType\JP_RentacarItem[] $carItem
     * @param \StructType\JP_InsuranceItem[] $insuranceItem
     * @param \StructType\JP_CruiseItem[] $cruiseItem
     * @param \StructType\JP_ServiceItem[] $serviceItem
     * @param \StructType\JP_TransferItem[] $transferItem
     * @param \StructType\JP_VisaItem[] $visaItem
     * @param \StructType\JP_AdjustmentItem[] $adjustmentItem
     */
    public function __construct(array $flightItem = array(), array $hotelItem = array(), array $packageItem = array(), array $carItem = array(), array $insuranceItem = array(), array $cruiseItem = array(), array $serviceItem = array(), array $transferItem = array(), array $visaItem = array(), array $adjustmentItem = array())
    {
        $this
            ->setFlightItem($flightItem)
            ->setHotelItem($hotelItem)
            ->setPackageItem($packageItem)
            ->setCarItem($carItem)
            ->setInsuranceItem($insuranceItem)
            ->setCruiseItem($cruiseItem)
            ->setServiceItem($serviceItem)
            ->setTransferItem($transferItem)
            ->setVisaItem($visaItem)
            ->setAdjustmentItem($adjustmentItem);
    }
    /**
     * Get FlightItem value
     * @return \StructType\JP_FlightItem[]|null
     */
    public function getFlightItem()
    {
        return $this->FlightItem;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightItemForArrayConstraintsFromSetFlightItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_ItemsFlightItemItem) {
            // validation for constraint: itemType
            if (!$jP_ItemsFlightItemItem instanceof \StructType\JP_FlightItem) {
                $invalidValues[] = is_object($jP_ItemsFlightItemItem) ? get_class($jP_ItemsFlightItemItem) : sprintf('%s(%s)', gettype($jP_ItemsFlightItemItem), var_export($jP_ItemsFlightItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightItem property can only contain items of type \StructType\JP_FlightItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_FlightItem[] $flightItem
     * @return \StructType\JP_Items
     */
    public function setFlightItem(array $flightItem = array())
    {
        // validation for constraint: array
        if ('' !== ($flightItemArrayErrorMessage = self::validateFlightItemForArrayConstraintsFromSetFlightItem($flightItem))) {
            throw new \InvalidArgumentException($flightItemArrayErrorMessage, __LINE__);
        }
        $this->FlightItem = $flightItem;
        return $this;
    }
    /**
     * Add item to FlightItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_FlightItem $item
     * @return \StructType\JP_Items
     */
    public function addToFlightItem(\StructType\JP_FlightItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_FlightItem) {
            throw new \InvalidArgumentException(sprintf('The FlightItem property can only contain items of type \StructType\JP_FlightItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FlightItem[] = $item;
        return $this;
    }
    /**
     * Get HotelItem value
     * @return \StructType\JP_HotelItem[]|null
     */
    public function getHotelItem()
    {
        return $this->HotelItem;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelItemForArrayConstraintsFromSetHotelItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_ItemsHotelItemItem) {
            // validation for constraint: itemType
            if (!$jP_ItemsHotelItemItem instanceof \StructType\JP_HotelItem) {
                $invalidValues[] = is_object($jP_ItemsHotelItemItem) ? get_class($jP_ItemsHotelItemItem) : sprintf('%s(%s)', gettype($jP_ItemsHotelItemItem), var_export($jP_ItemsHotelItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelItem property can only contain items of type \StructType\JP_HotelItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelItem[] $hotelItem
     * @return \StructType\JP_Items
     */
    public function setHotelItem(array $hotelItem = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelItemArrayErrorMessage = self::validateHotelItemForArrayConstraintsFromSetHotelItem($hotelItem))) {
            throw new \InvalidArgumentException($hotelItemArrayErrorMessage, __LINE__);
        }
        $this->HotelItem = $hotelItem;
        return $this;
    }
    /**
     * Add item to HotelItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelItem $item
     * @return \StructType\JP_Items
     */
    public function addToHotelItem(\StructType\JP_HotelItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_HotelItem) {
            throw new \InvalidArgumentException(sprintf('The HotelItem property can only contain items of type \StructType\JP_HotelItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelItem[] = $item;
        return $this;
    }
    /**
     * Get PackageItem value
     * @return \StructType\JP_PackageItem[]|null
     */
    public function getPackageItem()
    {
        return $this->PackageItem;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageItemForArrayConstraintsFromSetPackageItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_ItemsPackageItemItem) {
            // validation for constraint: itemType
            if (!$jP_ItemsPackageItemItem instanceof \StructType\JP_PackageItem) {
                $invalidValues[] = is_object($jP_ItemsPackageItemItem) ? get_class($jP_ItemsPackageItemItem) : sprintf('%s(%s)', gettype($jP_ItemsPackageItemItem), var_export($jP_ItemsPackageItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackageItem property can only contain items of type \StructType\JP_PackageItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PackageItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageItem[] $packageItem
     * @return \StructType\JP_Items
     */
    public function setPackageItem(array $packageItem = array())
    {
        // validation for constraint: array
        if ('' !== ($packageItemArrayErrorMessage = self::validatePackageItemForArrayConstraintsFromSetPackageItem($packageItem))) {
            throw new \InvalidArgumentException($packageItemArrayErrorMessage, __LINE__);
        }
        $this->PackageItem = $packageItem;
        return $this;
    }
    /**
     * Add item to PackageItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageItem $item
     * @return \StructType\JP_Items
     */
    public function addToPackageItem(\StructType\JP_PackageItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_PackageItem) {
            throw new \InvalidArgumentException(sprintf('The PackageItem property can only contain items of type \StructType\JP_PackageItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackageItem[] = $item;
        return $this;
    }
    /**
     * Get CarItem value
     * @return \StructType\JP_RentacarItem[]|null
     */
    public function getCarItem()
    {
        return $this->CarItem;
    }
    /**
     * This method is responsible for validating the values passed to the setCarItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCarItemForArrayConstraintsFromSetCarItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_ItemsCarItemItem) {
            // validation for constraint: itemType
            if (!$jP_ItemsCarItemItem instanceof \StructType\JP_RentacarItem) {
                $invalidValues[] = is_object($jP_ItemsCarItemItem) ? get_class($jP_ItemsCarItemItem) : sprintf('%s(%s)', gettype($jP_ItemsCarItemItem), var_export($jP_ItemsCarItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CarItem property can only contain items of type \StructType\JP_RentacarItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CarItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RentacarItem[] $carItem
     * @return \StructType\JP_Items
     */
    public function setCarItem(array $carItem = array())
    {
        // validation for constraint: array
        if ('' !== ($carItemArrayErrorMessage = self::validateCarItemForArrayConstraintsFromSetCarItem($carItem))) {
            throw new \InvalidArgumentException($carItemArrayErrorMessage, __LINE__);
        }
        $this->CarItem = $carItem;
        return $this;
    }
    /**
     * Add item to CarItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RentacarItem $item
     * @return \StructType\JP_Items
     */
    public function addToCarItem(\StructType\JP_RentacarItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_RentacarItem) {
            throw new \InvalidArgumentException(sprintf('The CarItem property can only contain items of type \StructType\JP_RentacarItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CarItem[] = $item;
        return $this;
    }
    /**
     * Get InsuranceItem value
     * @return \StructType\JP_InsuranceItem[]|null
     */
    public function getInsuranceItem()
    {
        return $this->InsuranceItem;
    }
    /**
     * This method is responsible for validating the values passed to the setInsuranceItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInsuranceItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInsuranceItemForArrayConstraintsFromSetInsuranceItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_ItemsInsuranceItemItem) {
            // validation for constraint: itemType
            if (!$jP_ItemsInsuranceItemItem instanceof \StructType\JP_InsuranceItem) {
                $invalidValues[] = is_object($jP_ItemsInsuranceItemItem) ? get_class($jP_ItemsInsuranceItemItem) : sprintf('%s(%s)', gettype($jP_ItemsInsuranceItemItem), var_export($jP_ItemsInsuranceItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InsuranceItem property can only contain items of type \StructType\JP_InsuranceItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InsuranceItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_InsuranceItem[] $insuranceItem
     * @return \StructType\JP_Items
     */
    public function setInsuranceItem(array $insuranceItem = array())
    {
        // validation for constraint: array
        if ('' !== ($insuranceItemArrayErrorMessage = self::validateInsuranceItemForArrayConstraintsFromSetInsuranceItem($insuranceItem))) {
            throw new \InvalidArgumentException($insuranceItemArrayErrorMessage, __LINE__);
        }
        $this->InsuranceItem = $insuranceItem;
        return $this;
    }
    /**
     * Add item to InsuranceItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_InsuranceItem $item
     * @return \StructType\JP_Items
     */
    public function addToInsuranceItem(\StructType\JP_InsuranceItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_InsuranceItem) {
            throw new \InvalidArgumentException(sprintf('The InsuranceItem property can only contain items of type \StructType\JP_InsuranceItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InsuranceItem[] = $item;
        return $this;
    }
    /**
     * Get CruiseItem value
     * @return \StructType\JP_CruiseItem[]|null
     */
    public function getCruiseItem()
    {
        return $this->CruiseItem;
    }
    /**
     * This method is responsible for validating the values passed to the setCruiseItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCruiseItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCruiseItemForArrayConstraintsFromSetCruiseItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_ItemsCruiseItemItem) {
            // validation for constraint: itemType
            if (!$jP_ItemsCruiseItemItem instanceof \StructType\JP_CruiseItem) {
                $invalidValues[] = is_object($jP_ItemsCruiseItemItem) ? get_class($jP_ItemsCruiseItemItem) : sprintf('%s(%s)', gettype($jP_ItemsCruiseItemItem), var_export($jP_ItemsCruiseItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CruiseItem property can only contain items of type \StructType\JP_CruiseItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CruiseItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CruiseItem[] $cruiseItem
     * @return \StructType\JP_Items
     */
    public function setCruiseItem(array $cruiseItem = array())
    {
        // validation for constraint: array
        if ('' !== ($cruiseItemArrayErrorMessage = self::validateCruiseItemForArrayConstraintsFromSetCruiseItem($cruiseItem))) {
            throw new \InvalidArgumentException($cruiseItemArrayErrorMessage, __LINE__);
        }
        $this->CruiseItem = $cruiseItem;
        return $this;
    }
    /**
     * Add item to CruiseItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CruiseItem $item
     * @return \StructType\JP_Items
     */
    public function addToCruiseItem(\StructType\JP_CruiseItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_CruiseItem) {
            throw new \InvalidArgumentException(sprintf('The CruiseItem property can only contain items of type \StructType\JP_CruiseItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CruiseItem[] = $item;
        return $this;
    }
    /**
     * Get ServiceItem value
     * @return \StructType\JP_ServiceItem[]|null
     */
    public function getServiceItem()
    {
        return $this->ServiceItem;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceItemForArrayConstraintsFromSetServiceItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_ItemsServiceItemItem) {
            // validation for constraint: itemType
            if (!$jP_ItemsServiceItemItem instanceof \StructType\JP_ServiceItem) {
                $invalidValues[] = is_object($jP_ItemsServiceItemItem) ? get_class($jP_ItemsServiceItemItem) : sprintf('%s(%s)', gettype($jP_ItemsServiceItemItem), var_export($jP_ItemsServiceItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceItem property can only contain items of type \StructType\JP_ServiceItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceItem[] $serviceItem
     * @return \StructType\JP_Items
     */
    public function setServiceItem(array $serviceItem = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceItemArrayErrorMessage = self::validateServiceItemForArrayConstraintsFromSetServiceItem($serviceItem))) {
            throw new \InvalidArgumentException($serviceItemArrayErrorMessage, __LINE__);
        }
        $this->ServiceItem = $serviceItem;
        return $this;
    }
    /**
     * Add item to ServiceItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceItem $item
     * @return \StructType\JP_Items
     */
    public function addToServiceItem(\StructType\JP_ServiceItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ServiceItem) {
            throw new \InvalidArgumentException(sprintf('The ServiceItem property can only contain items of type \StructType\JP_ServiceItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceItem[] = $item;
        return $this;
    }
    /**
     * Get TransferItem value
     * @return \StructType\JP_TransferItem[]|null
     */
    public function getTransferItem()
    {
        return $this->TransferItem;
    }
    /**
     * This method is responsible for validating the values passed to the setTransferItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransferItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransferItemForArrayConstraintsFromSetTransferItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_ItemsTransferItemItem) {
            // validation for constraint: itemType
            if (!$jP_ItemsTransferItemItem instanceof \StructType\JP_TransferItem) {
                $invalidValues[] = is_object($jP_ItemsTransferItemItem) ? get_class($jP_ItemsTransferItemItem) : sprintf('%s(%s)', gettype($jP_ItemsTransferItemItem), var_export($jP_ItemsTransferItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransferItem property can only contain items of type \StructType\JP_TransferItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransferItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_TransferItem[] $transferItem
     * @return \StructType\JP_Items
     */
    public function setTransferItem(array $transferItem = array())
    {
        // validation for constraint: array
        if ('' !== ($transferItemArrayErrorMessage = self::validateTransferItemForArrayConstraintsFromSetTransferItem($transferItem))) {
            throw new \InvalidArgumentException($transferItemArrayErrorMessage, __LINE__);
        }
        $this->TransferItem = $transferItem;
        return $this;
    }
    /**
     * Add item to TransferItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_TransferItem $item
     * @return \StructType\JP_Items
     */
    public function addToTransferItem(\StructType\JP_TransferItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_TransferItem) {
            throw new \InvalidArgumentException(sprintf('The TransferItem property can only contain items of type \StructType\JP_TransferItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransferItem[] = $item;
        return $this;
    }
    /**
     * Get VisaItem value
     * @return \StructType\JP_VisaItem[]|null
     */
    public function getVisaItem()
    {
        return $this->VisaItem;
    }
    /**
     * This method is responsible for validating the values passed to the setVisaItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVisaItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVisaItemForArrayConstraintsFromSetVisaItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_ItemsVisaItemItem) {
            // validation for constraint: itemType
            if (!$jP_ItemsVisaItemItem instanceof \StructType\JP_VisaItem) {
                $invalidValues[] = is_object($jP_ItemsVisaItemItem) ? get_class($jP_ItemsVisaItemItem) : sprintf('%s(%s)', gettype($jP_ItemsVisaItemItem), var_export($jP_ItemsVisaItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VisaItem property can only contain items of type \StructType\JP_VisaItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VisaItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_VisaItem[] $visaItem
     * @return \StructType\JP_Items
     */
    public function setVisaItem(array $visaItem = array())
    {
        // validation for constraint: array
        if ('' !== ($visaItemArrayErrorMessage = self::validateVisaItemForArrayConstraintsFromSetVisaItem($visaItem))) {
            throw new \InvalidArgumentException($visaItemArrayErrorMessage, __LINE__);
        }
        $this->VisaItem = $visaItem;
        return $this;
    }
    /**
     * Add item to VisaItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_VisaItem $item
     * @return \StructType\JP_Items
     */
    public function addToVisaItem(\StructType\JP_VisaItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_VisaItem) {
            throw new \InvalidArgumentException(sprintf('The VisaItem property can only contain items of type \StructType\JP_VisaItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VisaItem[] = $item;
        return $this;
    }
    /**
     * Get AdjustmentItem value
     * @return \StructType\JP_AdjustmentItem[]|null
     */
    public function getAdjustmentItem()
    {
        return $this->AdjustmentItem;
    }
    /**
     * This method is responsible for validating the values passed to the setAdjustmentItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdjustmentItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdjustmentItemForArrayConstraintsFromSetAdjustmentItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_ItemsAdjustmentItemItem) {
            // validation for constraint: itemType
            if (!$jP_ItemsAdjustmentItemItem instanceof \StructType\JP_AdjustmentItem) {
                $invalidValues[] = is_object($jP_ItemsAdjustmentItemItem) ? get_class($jP_ItemsAdjustmentItemItem) : sprintf('%s(%s)', gettype($jP_ItemsAdjustmentItemItem), var_export($jP_ItemsAdjustmentItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdjustmentItem property can only contain items of type \StructType\JP_AdjustmentItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdjustmentItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_AdjustmentItem[] $adjustmentItem
     * @return \StructType\JP_Items
     */
    public function setAdjustmentItem(array $adjustmentItem = array())
    {
        // validation for constraint: array
        if ('' !== ($adjustmentItemArrayErrorMessage = self::validateAdjustmentItemForArrayConstraintsFromSetAdjustmentItem($adjustmentItem))) {
            throw new \InvalidArgumentException($adjustmentItemArrayErrorMessage, __LINE__);
        }
        $this->AdjustmentItem = $adjustmentItem;
        return $this;
    }
    /**
     * Add item to AdjustmentItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_AdjustmentItem $item
     * @return \StructType\JP_Items
     */
    public function addToAdjustmentItem(\StructType\JP_AdjustmentItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_AdjustmentItem) {
            throw new \InvalidArgumentException(sprintf('The AdjustmentItem property can only contain items of type \StructType\JP_AdjustmentItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdjustmentItem[] = $item;
        return $this;
    }
}
