<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_BillingDataAFIP StructType
 * @subpackage Structs
 */
class JP_BillingDataAFIP extends AbstractStructBase
{
    /**
     * The BillingType
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $BillingType;
    /**
     * The BillingDocType
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $BillingDocType;
    /**
     * The FiscalCondition
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $FiscalCondition;
    /**
     * Constructor method for JP_BillingDataAFIP
     * @uses JP_BillingDataAFIP::setBillingType()
     * @uses JP_BillingDataAFIP::setBillingDocType()
     * @uses JP_BillingDataAFIP::setFiscalCondition()
     * @param string $billingType
     * @param int $billingDocType
     * @param int $fiscalCondition
     */
    public function __construct($billingType = null, $billingDocType = null, $fiscalCondition = null)
    {
        $this
            ->setBillingType($billingType)
            ->setBillingDocType($billingDocType)
            ->setFiscalCondition($fiscalCondition);
    }
    /**
     * Get BillingType value
     * @return string
     */
    public function getBillingType()
    {
        return $this->BillingType;
    }
    /**
     * Set BillingType value
     * @uses \EnumType\JP_BillingType::valueIsValid()
     * @uses \EnumType\JP_BillingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $billingType
     * @return \StructType\JP_BillingDataAFIP
     */
    public function setBillingType($billingType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_BillingType::valueIsValid($billingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_BillingType', is_array($billingType) ? implode(', ', $billingType) : var_export($billingType, true), implode(', ', \EnumType\JP_BillingType::getValidValues())), __LINE__);
        }
        $this->BillingType = $billingType;
        return $this;
    }
    /**
     * Get BillingDocType value
     * @return int
     */
    public function getBillingDocType()
    {
        return $this->BillingDocType;
    }
    /**
     * Set BillingDocType value
     * @param int $billingDocType
     * @return \StructType\JP_BillingDataAFIP
     */
    public function setBillingDocType($billingDocType = null)
    {
        // validation for constraint: int
        if (!is_null($billingDocType) && !(is_int($billingDocType) || ctype_digit($billingDocType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($billingDocType, true), gettype($billingDocType)), __LINE__);
        }
        $this->BillingDocType = $billingDocType;
        return $this;
    }
    /**
     * Get FiscalCondition value
     * @return int
     */
    public function getFiscalCondition()
    {
        return $this->FiscalCondition;
    }
    /**
     * Set FiscalCondition value
     * @param int $fiscalCondition
     * @return \StructType\JP_BillingDataAFIP
     */
    public function setFiscalCondition($fiscalCondition = null)
    {
        // validation for constraint: int
        if (!is_null($fiscalCondition) && !(is_int($fiscalCondition) || ctype_digit($fiscalCondition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fiscalCondition, true), gettype($fiscalCondition)), __LINE__);
        }
        $this->FiscalCondition = $fiscalCondition;
        return $this;
    }
}
