<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Shopping ServiceType
 * @subpackage Services
 */
class Shopping extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ShoppingBasketRead
     * Meta information extracted from the WSDL
     * - documentation: Get stored booking pricing.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShoppingBasketRead $parameters
     * @return \StructType\ShoppingBasketReadResponse|bool
     */
    public function ShoppingBasketRead(\StructType\ShoppingBasketRead $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShoppingBasketRead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ShoppingBasketSave
     * Meta information extracted from the WSDL
     * - documentation: Store booking pricing.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShoppingBasketSave $parameters
     * @return \StructType\ShoppingBasketSaveResponse|bool
     */
    public function ShoppingBasketSave(\StructType\ShoppingBasketSave $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShoppingBasketSave($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ShoppingBasketReadResponse|\StructType\ShoppingBasketSaveResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
