<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_FlightSegment StructType
 * @subpackage Structs
 */
class JP_FlightSegment extends AbstractStructBase
{
    /**
     * The DepartureDate
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $DepartureDate;
    /**
     * The ArrivalDate
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ArrivalDate;
    /**
     * The Equipments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Equipment
     */
    public $Equipments;
    /**
     * The TechnicalStops
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_TechnicalStop
     */
    public $TechnicalStops;
    /**
     * The SeatingMap
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_SeatingMap
     */
    public $SeatingMap;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * The Stops
     * @var int
     */
    public $Stops;
    /**
     * The DepartureAirport
     * @var string
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * @var string
     */
    public $ArrivalAirport;
    /**
     * The OperatingAirline
     * @var string
     */
    public $OperatingAirline;
    /**
     * The MarquetingAirline
     * @var string
     */
    public $MarquetingAirline;
    /**
     * The FlightNumber
     * @var string
     */
    public $FlightNumber;
    /**
     * The JourneyDuration
     * @var string
     */
    public $JourneyDuration;
    /**
     * The GroundDuration
     * @var string
     */
    public $GroundDuration;
    /**
     * The Class
     * @var string
     */
    public $Class;
    /**
     * The Meal
     * @var string
     */
    public $Meal;
    /**
     * The Cabin
     * @var string
     */
    public $Cabin;
    /**
     * The AirplaneType
     * @var string
     */
    public $AirplaneType;
    /**
     * The FareBasis
     * @var string
     */
    public $FareBasis;
    /**
     * The VendorLocator
     * @var string
     */
    public $VendorLocator;
    /**
     * Constructor method for JP_FlightSegment
     * @uses JP_FlightSegment::setDepartureDate()
     * @uses JP_FlightSegment::setArrivalDate()
     * @uses JP_FlightSegment::setEquipments()
     * @uses JP_FlightSegment::setTechnicalStops()
     * @uses JP_FlightSegment::setSeatingMap()
     * @uses JP_FlightSegment::setOrder()
     * @uses JP_FlightSegment::setStops()
     * @uses JP_FlightSegment::setDepartureAirport()
     * @uses JP_FlightSegment::setArrivalAirport()
     * @uses JP_FlightSegment::setOperatingAirline()
     * @uses JP_FlightSegment::setMarquetingAirline()
     * @uses JP_FlightSegment::setFlightNumber()
     * @uses JP_FlightSegment::setJourneyDuration()
     * @uses JP_FlightSegment::setGroundDuration()
     * @uses JP_FlightSegment::setClass()
     * @uses JP_FlightSegment::setMeal()
     * @uses JP_FlightSegment::setCabin()
     * @uses JP_FlightSegment::setAirplaneType()
     * @uses JP_FlightSegment::setFareBasis()
     * @uses JP_FlightSegment::setVendorLocator()
     * @param string $departureDate
     * @param string $arrivalDate
     * @param \ArrayType\ArrayOfJP_Equipment $equipments
     * @param \ArrayType\ArrayOfJP_TechnicalStop $technicalStops
     * @param \StructType\JP_SeatingMap $seatingMap
     * @param int $order
     * @param int $stops
     * @param string $departureAirport
     * @param string $arrivalAirport
     * @param string $operatingAirline
     * @param string $marquetingAirline
     * @param string $flightNumber
     * @param string $journeyDuration
     * @param string $groundDuration
     * @param string $class
     * @param string $meal
     * @param string $cabin
     * @param string $airplaneType
     * @param string $fareBasis
     * @param string $vendorLocator
     */
    public function __construct($departureDate = null, $arrivalDate = null, \ArrayType\ArrayOfJP_Equipment $equipments = null, \ArrayType\ArrayOfJP_TechnicalStop $technicalStops = null, \StructType\JP_SeatingMap $seatingMap = null, $order = null, $stops = null, $departureAirport = null, $arrivalAirport = null, $operatingAirline = null, $marquetingAirline = null, $flightNumber = null, $journeyDuration = null, $groundDuration = null, $class = null, $meal = null, $cabin = null, $airplaneType = null, $fareBasis = null, $vendorLocator = null)
    {
        $this
            ->setDepartureDate($departureDate)
            ->setArrivalDate($arrivalDate)
            ->setEquipments($equipments)
            ->setTechnicalStops($technicalStops)
            ->setSeatingMap($seatingMap)
            ->setOrder($order)
            ->setStops($stops)
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport)
            ->setOperatingAirline($operatingAirline)
            ->setMarquetingAirline($marquetingAirline)
            ->setFlightNumber($flightNumber)
            ->setJourneyDuration($journeyDuration)
            ->setGroundDuration($groundDuration)
            ->setClass($class)
            ->setMeal($meal)
            ->setCabin($cabin)
            ->setAirplaneType($airplaneType)
            ->setFareBasis($fareBasis)
            ->setVendorLocator($vendorLocator);
    }
    /**
     * Get DepartureDate value
     * @return string
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\JP_FlightSegment
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get ArrivalDate value
     * @return string
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\JP_FlightSegment
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDate, true), gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get Equipments value
     * @return \ArrayType\ArrayOfJP_Equipment|null
     */
    public function getEquipments()
    {
        return $this->Equipments;
    }
    /**
     * Set Equipments value
     * @param \ArrayType\ArrayOfJP_Equipment $equipments
     * @return \StructType\JP_FlightSegment
     */
    public function setEquipments(\ArrayType\ArrayOfJP_Equipment $equipments = null)
    {
        $this->Equipments = $equipments;
        return $this;
    }
    /**
     * Get TechnicalStops value
     * @return \ArrayType\ArrayOfJP_TechnicalStop|null
     */
    public function getTechnicalStops()
    {
        return $this->TechnicalStops;
    }
    /**
     * Set TechnicalStops value
     * @param \ArrayType\ArrayOfJP_TechnicalStop $technicalStops
     * @return \StructType\JP_FlightSegment
     */
    public function setTechnicalStops(\ArrayType\ArrayOfJP_TechnicalStop $technicalStops = null)
    {
        $this->TechnicalStops = $technicalStops;
        return $this;
    }
    /**
     * Get SeatingMap value
     * @return \StructType\JP_SeatingMap|null
     */
    public function getSeatingMap()
    {
        return $this->SeatingMap;
    }
    /**
     * Set SeatingMap value
     * @param \StructType\JP_SeatingMap $seatingMap
     * @return \StructType\JP_FlightSegment
     */
    public function setSeatingMap(\StructType\JP_SeatingMap $seatingMap = null)
    {
        $this->SeatingMap = $seatingMap;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\JP_FlightSegment
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Stops value
     * @return int|null
     */
    public function getStops()
    {
        return $this->Stops;
    }
    /**
     * Set Stops value
     * @param int $stops
     * @return \StructType\JP_FlightSegment
     */
    public function setStops($stops = null)
    {
        // validation for constraint: int
        if (!is_null($stops) && !(is_int($stops) || ctype_digit($stops))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stops, true), gettype($stops)), __LINE__);
        }
        $this->Stops = $stops;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return string|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param string $departureAirport
     * @return \StructType\JP_FlightSegment
     */
    public function setDepartureAirport($departureAirport = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirport) && !is_string($departureAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureAirport, true), gettype($departureAirport)), __LINE__);
        }
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return string|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param string $arrivalAirport
     * @return \StructType\JP_FlightSegment
     */
    public function setArrivalAirport($arrivalAirport = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalAirport) && !is_string($arrivalAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalAirport, true), gettype($arrivalAirport)), __LINE__);
        }
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get OperatingAirline value
     * @return string|null
     */
    public function getOperatingAirline()
    {
        return $this->OperatingAirline;
    }
    /**
     * Set OperatingAirline value
     * @param string $operatingAirline
     * @return \StructType\JP_FlightSegment
     */
    public function setOperatingAirline($operatingAirline = null)
    {
        // validation for constraint: string
        if (!is_null($operatingAirline) && !is_string($operatingAirline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingAirline, true), gettype($operatingAirline)), __LINE__);
        }
        $this->OperatingAirline = $operatingAirline;
        return $this;
    }
    /**
     * Get MarquetingAirline value
     * @return string|null
     */
    public function getMarquetingAirline()
    {
        return $this->MarquetingAirline;
    }
    /**
     * Set MarquetingAirline value
     * @param string $marquetingAirline
     * @return \StructType\JP_FlightSegment
     */
    public function setMarquetingAirline($marquetingAirline = null)
    {
        // validation for constraint: string
        if (!is_null($marquetingAirline) && !is_string($marquetingAirline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marquetingAirline, true), gettype($marquetingAirline)), __LINE__);
        }
        $this->MarquetingAirline = $marquetingAirline;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \StructType\JP_FlightSegment
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get JourneyDuration value
     * @return string|null
     */
    public function getJourneyDuration()
    {
        return $this->JourneyDuration;
    }
    /**
     * Set JourneyDuration value
     * @param string $journeyDuration
     * @return \StructType\JP_FlightSegment
     */
    public function setJourneyDuration($journeyDuration = null)
    {
        // validation for constraint: string
        if (!is_null($journeyDuration) && !is_string($journeyDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($journeyDuration, true), gettype($journeyDuration)), __LINE__);
        }
        $this->JourneyDuration = $journeyDuration;
        return $this;
    }
    /**
     * Get GroundDuration value
     * @return string|null
     */
    public function getGroundDuration()
    {
        return $this->GroundDuration;
    }
    /**
     * Set GroundDuration value
     * @param string $groundDuration
     * @return \StructType\JP_FlightSegment
     */
    public function setGroundDuration($groundDuration = null)
    {
        // validation for constraint: string
        if (!is_null($groundDuration) && !is_string($groundDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groundDuration, true), gettype($groundDuration)), __LINE__);
        }
        $this->GroundDuration = $groundDuration;
        return $this;
    }
    /**
     * Get Class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->Class;
    }
    /**
     * Set Class value
     * @param string $class
     * @return \StructType\JP_FlightSegment
     */
    public function setClass($class = null)
    {
        // validation for constraint: string
        if (!is_null($class) && !is_string($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($class, true), gettype($class)), __LINE__);
        }
        $this->Class = $class;
        return $this;
    }
    /**
     * Get Meal value
     * @return string|null
     */
    public function getMeal()
    {
        return $this->Meal;
    }
    /**
     * Set Meal value
     * @param string $meal
     * @return \StructType\JP_FlightSegment
     */
    public function setMeal($meal = null)
    {
        // validation for constraint: string
        if (!is_null($meal) && !is_string($meal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meal, true), gettype($meal)), __LINE__);
        }
        $this->Meal = $meal;
        return $this;
    }
    /**
     * Get Cabin value
     * @return string|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @param string $cabin
     * @return \StructType\JP_FlightSegment
     */
    public function setCabin($cabin = null)
    {
        // validation for constraint: string
        if (!is_null($cabin) && !is_string($cabin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabin, true), gettype($cabin)), __LINE__);
        }
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get AirplaneType value
     * @return string|null
     */
    public function getAirplaneType()
    {
        return $this->AirplaneType;
    }
    /**
     * Set AirplaneType value
     * @param string $airplaneType
     * @return \StructType\JP_FlightSegment
     */
    public function setAirplaneType($airplaneType = null)
    {
        // validation for constraint: string
        if (!is_null($airplaneType) && !is_string($airplaneType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airplaneType, true), gettype($airplaneType)), __LINE__);
        }
        $this->AirplaneType = $airplaneType;
        return $this;
    }
    /**
     * Get FareBasis value
     * @return string|null
     */
    public function getFareBasis()
    {
        return $this->FareBasis;
    }
    /**
     * Set FareBasis value
     * @param string $fareBasis
     * @return \StructType\JP_FlightSegment
     */
    public function setFareBasis($fareBasis = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasis) && !is_string($fareBasis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasis, true), gettype($fareBasis)), __LINE__);
        }
        $this->FareBasis = $fareBasis;
        return $this;
    }
    /**
     * Get VendorLocator value
     * @return string|null
     */
    public function getVendorLocator()
    {
        return $this->VendorLocator;
    }
    /**
     * Set VendorLocator value
     * @param string $vendorLocator
     * @return \StructType\JP_FlightSegment
     */
    public function setVendorLocator($vendorLocator = null)
    {
        // validation for constraint: string
        if (!is_null($vendorLocator) && !is_string($vendorLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorLocator, true), gettype($vendorLocator)), __LINE__);
        }
        $this->VendorLocator = $vendorLocator;
        return $this;
    }
}
